% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{barplot.shapeNA}
\alias{barplot.shapeNA}
\title{Barplot Showcasing Missingness Proportion of the Original Data}
\usage{
\method{barplot}{shapeNA}(height, sortNA = FALSE, ...)
}
\arguments{
\item{height}{A \code{shapeNA} object.}

\item{sortNA}{A logical. If \code{FALSE}, the original variable order is kept.
Otherwise the variables are ordered from least to most missingness.}

\item{...}{Additional graphical arguments passed to
\code{\link[graphics]{barplot}}.}
}
\value{
Invisibly returns a named vector holding the proportion of
missingness per variable.
}
\description{
Visualize the proportion of missingness per variable in a barplot.
}
\examples{
    S <- toeplitz(seq(1, 0.1, length.out = 3))
    x <- mvtnorm::rmvt(100, S, df = 5)
    y <- mice::ampute(x, mech='MCAR')$amp
    res <- classicShapeNA(y)
    barplot(res)
}
\seealso{
\code{\link[graphics]{barplot}}
}
