% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgraph_utils.R
\name{add_igraph_info}
\alias{add_igraph_info}
\title{Add nodes information to the igraph object}
\usage{
add_igraph_info(igraph, df_nodes, fields = names(df_nodes))
}
\arguments{
\item{igraph}{Igraph object to modify}

\item{df_nodes}{Data frame to add to nodes}

\item{fields}{Columns of df_nodes to add.
First must be the node identifier.}
}
\value{
A sgraph object with modified node labels
}
\description{
Modify the node attributes of an existing igraph object by providing a
dataframe
}
\examples{
library(igraph)
library(sgraph)
data(lesMis)

df_nodes = cbind.data.frame(name = igraph::vertex_attr(lesMis, 'label'),
  log10_degree = degree(lesMis))

igraph = add_igraph_info(lesMis, df_nodes)

sig <- sigma_from_igraph(lesMis) \%>\%
  add_node_size(size_vector = 'log10_degree')

}
