% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.npc.R
\name{plotnpc}
\alias{plotnpc}
\title{Plotting a natural cubic splines or P-splines.}
\usage{
plotnpc(fit, conf_lev)
}
\arguments{
\item{fit}{an object of the class sglg. This object is returned from the call to glg(), sglg(), survglg() or ssurvglg().}

\item{conf_lev}{is the confidence level of the asymptotic confidence band. Default value is 0.05.}
}
\description{
\code{plotnpc} displays a graph of a fitted nonparametric effect, either natural cubic spline or P-spline, from an object of class sglg.
}
\examples{
set.seed(1)
n <- 300
error <- rglg(n,0,0.5,1)
t <- as.matrix((2*1:n - 1)/(2*n))
colnames(t) <- "t"
f_t <- cos(4*pi*t)
y <- 0.8 + f_t + error
colnames(y) <- "y"
data <- as.data.frame(cbind(y,1,t))
fit1 <- sglg(y ~ 1,npc=t,data=data,basis = "deBoor",alpha0=0.0001)
summary(fit1)
# The adjusted (black) non-linear component
plotnpc(fit1,conf_lev=0.02)
}
\references{
Eilers P.H.C. and Marx B.D. (1996). Flexible smoothing with B-splines and penalties. Statistical Science. 11, 89-121.

Wood, S. (2017). Additive generalized models: An R introduction. Chapman and Hall.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
