% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sffdr}
\alias{plot.sffdr}
\alias{plot,}
\title{Plotting function for sffdr object}
\usage{
\method{plot}{sffdr}(x, rng = c(0, 5e-08), ...)
}
\arguments{
\item{x}{A sffdr object.}

\item{rng}{Significance region to show. Optional.}

\item{\ldots}{Additional arguments. Currently unused.}
}
\value{
Plotting function to summarize significance results from sffdr.
}
\description{
Graphical display of the sffdr object
}
\examples{
\donttest{
# import data
data(bmi)

# separate main p-values and conditioning p-values
p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# apply pi0_model to create model
knots <- c(0.005, 0.01, 0.025, 0.05, 0.1)
fmod <- pi0_model(z, knots = knots)

# estimate functional pi0
fpi0_out <- fpi0est(p, z = fmod$zt, pi0_model = fmod$fmod)
fpi0 <- fpi0_out$fpi0

# apply sffdr
# Note all tests are independent see 'indep_snps' argument
# The very small p-values, set epsilon to min of p
sffdr_out <- sffdr(p, fpi0, epsilon = min(p))

# Plot significance results
plot(sffdr_out, rng = c(0, 5e-4))
}
}
\seealso{
\code{\link{sffdr}}
}
\author{
Andrew J. Bass
}
\keyword{plot}
