% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_matrix.R
\name{wt_as_matrix}
\alias{wt_as_matrix}
\alias{nb_as_matrix}
\title{Convert neighbor or weights list to matrix}
\usage{
wt_as_matrix(nb, wt)

nb_as_matrix(nb)
}
\arguments{
\item{nb}{a neighbor list—i.e. as created by \code{st_contiguity()}.}

\item{wt}{a weights list—i.e. as created by \code{st_weights()}}
}
\value{
Returns a n x n matrix
}
\description{
Given a \code{nb} list or weights list, convert them to a matrix.
}
\examples{

# make a grid
g <- sf::st_make_grid(
  cellsize = c(10, 10),
  offset = c(0, 0),
  n = c(2, 2)
)

# create neighbors
nb <- st_contiguity(g)

# cast to matrix
nb_as_matrix(nb)

# create weights
wt <- st_weights(nb)

# cast as matrix
wt_as_matrix(nb, wt)

}
