% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbors.R
\name{st_nb_lag_cumul}
\alias{st_nb_lag_cumul}
\title{Encompassing Higher Order Neighbors}
\usage{
st_nb_lag_cumul(nb, order)
}
\arguments{
\item{nb}{A neighbor list object as created by \code{st_contiguity()}.}

\item{order}{The order of neighbors.}
}
\value{
a list of class \code{nb}
}
\description{
Creates an encompassing neighbor list of the order specified.
For example, if the order is 2 the result contains both 1st
and 2nd order neighbors.
}
\details{
Utilizes \code{\link[spdep:nblag]{spdep::nblag_cumul()}}
}
\examples{
nb <- st_contiguity(sf::st_geometry(guerry))
st_nb_lag_cumul(nb, 3)
}
\seealso{
Other other: 
\code{\link{st_cardinalties}()},
\code{\link{st_nb_lag}()}
}
\concept{other}
