% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_jc_perm}
\alias{global_jc_perm}
\alias{global_jc_test}
\alias{tally_jc}
\title{Global Join Counts}
\usage{
global_jc_perm(
  fx,
  nb,
  wt,
  alternative = "greater",
  nsim = 499,
  allow_zero = FALSE,
  ...
)

global_jc_test(fx, nb, wt, alternative = "greater", allow_zero = NULL, ...)

tally_jc(fx, nb, wt, allow_zero = TRUE, ...)
}
\arguments{
\item{fx}{a factor or character vector of the same length as nb.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{nsim}{number of simulations to run.}

\item{allow_zero}{If \code{TRUE}, assigns zero as lagged value to zone without neighbors.}

\item{...}{additional arguments passed to methods}
}
\value{
an object of class \code{jclist} which is a list where each element is of class \code{htest} and \code{mc.sim}.
}
\description{
Calculate global join count measure for a categorical variable.
}
\details{
\itemize{
\item \code{global_jc_perm()} implements the monte-carlo based join count using \code{spdep::joincount.mc()}
\item \code{global_jc_test()} implements the traditional BB join count statistic using \code{spdep::joincount.test()}
\item \code{tally_jc()} calculated join counts for a variable \code{fx} and returns a data.frame using \code{spdep::joincount.multi()}
}
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
wt <- st_weights(nb, style = "B")
fx <- guerry$region
global_jc_perm(fx, nb, wt)

global_jc_test(fx, nb, wt)

tally_jc(fx, nb, wt)
}
