% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_validate.R
\name{sfc_validate,sfc_sequence-method}
\alias{sfc_validate,sfc_sequence-method}
\alias{sfc_validate}
\alias{sfc_validate,character-method}
\title{Validate the sequence}
\usage{
\S4method{sfc_validate}{sfc_sequence}(p, by = "sfc_2x2")

\S4method{sfc_validate}{character}(p, by = "sfc_2x2")
}
\arguments{
\item{p}{An \code{sfc_sequence} object or a character string. If it is a character string, rotation of zero is assigned to the first letter.}

\item{by}{One of \code{sfc_2x2}, \code{sfc_3x3_peano} and \code{sfc_3x3_meander}.}
}
\value{
A logical scalar.
}
\description{
Validate the sequence
}
\details{
It is mainly used to validate a seed sequence whether they follow the forward-left-right rule.
}
\examples{
try(sfc_validate("LLLLL"))
try(sfc_validate(sfc_sequence("IIIII", rot = c(0, 90, 180, 270, 0), 
        universe = sfc_universe(SFC_RULES_2x2))))
}
