% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sever.R
\name{sever}
\alias{sever}
\title{Sever}
\usage{
sever(
  html = sever_default(),
  color = "#fff",
  opacity = 1,
  bg_color = "#333e48",
  bg_image = NULL,
  session = shiny::getDefaultReactiveDomain(),
  box = FALSE
)
}
\arguments{
\item{html}{Shiny tags to use as content for the disconnected screen,
generally \code{\link[shiny:reexports]{shiny::tagList()}}.}

\item{opacity}{Opacity of background.}

\item{bg_color, color}{Background color, color of text.}

\item{bg_image}{Background image to use.}

\item{session}{A valid shiny session.}

\item{box}{Set to \code{TRUE} to enclose the \code{html} in a box.}
}
\value{
None
}
\description{
Customise the Shiny disconnected screen.
}
\examples{
library(shiny)

ui <- fluidPage(
 useSever(),
 h1("sever")
)

server <- function(input, output){
 sever(
   tagList(
     h1("Whoops"),
     reload_button()
   )
 )
}

if(interactive())
 shinyApp(ui, server)

}
