% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-teams.R
\name{Teams}
\alias{Teams}
\title{R6 Class representing teams endpoints}
\description{
R6 Class representing teams resource endpoints.
}
\examples{

## ------------------------------------------------
## Method `Teams$query`
## ------------------------------------------------

\dontrun{
  # Retrieve a list of all teams within the division regardless of
  # whether you are a member of a team or not
  a$teams$query(division = "division-id", list_all = TRUE)
}


## ------------------------------------------------
## Method `Teams$get`
## ------------------------------------------------

\dontrun{
  # Retrieve details of a specified team
  a$teams$get(id = "team-id")
}

## ------------------------------------------------
## Method `Teams$create`
## ------------------------------------------------

\dontrun{
  # Create new team
  a$teams$create(division = "division-id", name = "my-new-team")
}


## ------------------------------------------------
## Method `Teams$delete`
## ------------------------------------------------

\dontrun{
  # Delete a team
  a$teams$delete(team = "team-id")
}
}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Teams}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Teams-new}{\code{Teams$new()}}
\item \href{#method-Teams-query}{\code{Teams$query()}}
\item \href{#method-Teams-get}{\code{Teams$get()}}
\item \href{#method-Teams-create}{\code{Teams$create()}}
\item \href{#method-Teams-delete}{\code{Teams$delete()}}
\item \href{#method-Teams-clone}{\code{Teams$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Teams-new"></a>}}
\if{latex}{\out{\hypertarget{method-Teams-new}{}}}
\subsection{Method \code{new()}}{
Create new Teams resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Teams$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Teams-query"></a>}}
\if{latex}{\out{\hypertarget{method-Teams-query}{}}}
\subsection{Method \code{query()}}{
This call retrieves a list of all teams in a division that
you are a member of. Each team's ID and name will be returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Teams$query(division, list_all = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{division}}{The string ID of the division or Division object
you are querying.}

\item{\code{list_all}}{Boolean. Set this field to \code{TRUE} if you want to list
all teams within the division (regardless of whether you are a member
of a team or not). Default value is \code{FALSE}.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{Collection}} of \code{\link{Team}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  # Retrieve a list of all teams within the division regardless of
  # whether you are a member of a team or not
  a$teams$query(division = "division-id", list_all = TRUE)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Teams-get"></a>}}
\if{latex}{\out{\hypertarget{method-Teams-get}{}}}
\subsection{Method \code{get()}}{
This call returns the details of a specified team.
You can only get details of a team you are a member of.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Teams$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the team you are querying. The function
also accepts a Team object and extracts the ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Team}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  # Retrieve details of a specified team
  a$teams$get(id = "team-id")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Teams-create"></a>}}
\if{latex}{\out{\hypertarget{method-Teams-create}{}}}
\subsection{Method \code{create()}}{
This call creates a new team within a specified division.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Teams$create(division, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{division}}{The string ID of the division or Division object
where you want to create a team.}

\item{\code{name}}{Enter the name for the new team.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{Team}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  # Create new team
  a$teams$create(division = "division-id", name = "my-new-team")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Teams-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Teams-delete}{}}}
\subsection{Method \code{delete()}}{
This call deletes a team. By deleting a team, you remove
the users' membership to the team, but do not remove their accounts
from the division.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Teams$delete(team, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{team}}{The team ID or Team object that you want to delete.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  # Delete a team
  a$teams$delete(team = "team-id")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Teams-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Teams-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Teams$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
