% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-files.R
\name{Files}
\alias{Files}
\title{R6 Class representing files endpoints.}
\description{
R6 Class representing Files resource.
}
\examples{

## ------------------------------------------------
## Method `Files$query`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Query files in a project
 files_object$query(project = project)
}


## ------------------------------------------------
## Method `Files$get`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Get file using id
 files_object$get(id = id)
}


## ------------------------------------------------
## Method `Files$delete`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Delete a file
 files_object$delete(file = file)
}


## ------------------------------------------------
## Method `Files$copy`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Copy files to a project
 files_object$copy(
               file = file,
               destination_project = project
              )
}


## ------------------------------------------------
## Method `Files$create_folder`
## ------------------------------------------------

\dontrun{
 files_object <- Files$new(auth = auth)

 # Create folder in a project
 files_object$create_folder(
                name = name,
                project = project
               )
}


## ------------------------------------------------
## Method `Files$bulk_delete`
## ------------------------------------------------

\dontrun{
 # Delete two files by providing their IDs
 a$files$bulk_delete(files = list("file_1_ID", "file_2_ID"))
}

\dontrun{
 # Delete two files by providing a list of File objects
 a$files$bulk_delete(files = list(File_Object_1, File_Object_2))
}


## ------------------------------------------------
## Method `Files$bulk_get`
## ------------------------------------------------

\dontrun{
 # Get details of multiple files
 a$files$bulk_get(
               files = list("file_1_ID", "file_2_ID")
              )
}


## ------------------------------------------------
## Method `Files$bulk_update`
## ------------------------------------------------

\dontrun{
 # Update details of multiple files
 a$files$bulk_update(
               files = list(File_Object_1, File_Object_2)
              )
}


## ------------------------------------------------
## Method `Files$bulk_edit`
## ------------------------------------------------

\dontrun{
 # Edit details of multiple files
 a$files$bulk_edit(
               files = list(File_Object_1, File_Object_2)
              )
}


## ------------------------------------------------
## Method `Files$async_bulk_copy`
## ------------------------------------------------

\dontrun{
 # Copy multiple files
 a$files$async_bulk_copy(
   items = list(
           list(
             file = '<file-id-1>',
             parent = '<folder-id>'
           ),
           list(
             file = '<file-id-2>',
             project = '<project-id-1>',
             name = 'copied_file.txt'
           ),
           list(
             file = '<file-id-3>',
             parent = '<parent-id-2>',
             name = 'copied_file2.txt'
           )
         )
  )
}


## ------------------------------------------------
## Method `Files$async_bulk_delete`
## ------------------------------------------------

\dontrun{
 # Delete multiple files
 a$files$async_bulk_delete(
   items = list(file_obj1, file_obj2, "<folder-id-string>", "<file-id>")
 )
}


## ------------------------------------------------
## Method `Files$async_bulk_move`
## ------------------------------------------------

\dontrun{
 # Move multiple files
 a$files$async_bulk_move(
   items = list(
           list(
             file = '<file-id-1>',
             parent = '<folder-id>'
           ),
           list(
             file = '<file-id-2>',
             project = '<project-id-1>',
             name = 'moved_file.txt'
           ),
           list(
             file = '<file-id-3>',
             parent = '<parent-id-2>',
             name = 'moved_file2.txt'
           )
         )
  )
}


## ------------------------------------------------
## Method `Files$async_get_copy_job`
## ------------------------------------------------

\dontrun{
 # Get details of an async copy job
 a$files$async_get_copy_job(job_id = "job-id")
}


## ------------------------------------------------
## Method `Files$async_get_delete_job`
## ------------------------------------------------

\dontrun{
 # Get details of an async delete job
 a$files$async_get_delete_job(job_id = "job-id")
}


## ------------------------------------------------
## Method `Files$async_get_move_job`
## ------------------------------------------------

\dontrun{
 # Get details of an async move job
 a$files$async_get_move_job(job_id = "job-id")
}


## ------------------------------------------------
## Method `Files$async_list_file_jobs`
## ------------------------------------------------

\dontrun{
 # Get details of the first 5 async jobs
 a$files$async_list_file_jobs(limit = 5)
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Files}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Files-new}{\code{Files$new()}}
\item \href{#method-Files-query}{\code{Files$query()}}
\item \href{#method-Files-get}{\code{Files$get()}}
\item \href{#method-Files-delete}{\code{Files$delete()}}
\item \href{#method-Files-copy}{\code{Files$copy()}}
\item \href{#method-Files-create_folder}{\code{Files$create_folder()}}
\item \href{#method-Files-bulk_delete}{\code{Files$bulk_delete()}}
\item \href{#method-Files-bulk_get}{\code{Files$bulk_get()}}
\item \href{#method-Files-bulk_update}{\code{Files$bulk_update()}}
\item \href{#method-Files-bulk_edit}{\code{Files$bulk_edit()}}
\item \href{#method-Files-async_bulk_copy}{\code{Files$async_bulk_copy()}}
\item \href{#method-Files-async_bulk_delete}{\code{Files$async_bulk_delete()}}
\item \href{#method-Files-async_bulk_move}{\code{Files$async_bulk_move()}}
\item \href{#method-Files-async_get_copy_job}{\code{Files$async_get_copy_job()}}
\item \href{#method-Files-async_get_delete_job}{\code{Files$async_get_delete_job()}}
\item \href{#method-Files-async_get_move_job}{\code{Files$async_get_move_job()}}
\item \href{#method-Files-async_list_file_jobs}{\code{Files$async_list_file_jobs()}}
\item \href{#method-Files-clone}{\code{Files$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-new"></a>}}
\if{latex}{\out{\hypertarget{method-Files-new}{}}}
\subsection{Method \code{new()}}{
Create new Files resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-query"></a>}}
\if{latex}{\out{\hypertarget{method-Files-query}{}}}
\subsection{Method \code{query()}}{
This call returns a list of files and subdirectories in a
specified project or directory within a project, with specified
properties that you can access. The project or directory whose contents
you want to list is specified as a query parameter in the call. Further
properties to filter by can also be specified as query parameters.
\cr \cr
Note that this call lists both files and subdirectories in the
specified project or directory within a project, but not the contents
of the subdirectories. \cr
To list the contents of a subdirectory, make a new call
and specify the subdirectory ID as the \code{parent} parameter. \cr
For more details, see our
\href{https://docs.sevenbridges.com/reference/list-files-primary-method}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$query(
  project = NULL,
  parent = NULL,
  name = NULL,
  metadata = NULL,
  origin = NULL,
  tag = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{Project identifier (ID) as string or a Project object.
Project should not be used together with parent.
If parent is used, the call will list the content of the specified
folder, within the project to which the folder belongs.
If project is used, the call will list the content at the root of
the project's files.}

\item{\code{parent}}{The parent folder identifier as string or a File object
which must be of type \code{FOLDER}.
Should not be used together with project.
If parent is used, the call will list the content of the specified
folder, within the project to which the folder belongs.
If project is used, the call will list the content at the root of
the project's files.}

\item{\code{name}}{Name of the file. List files with this name. Note that the
name must be an exact complete string for the results to match.
Multiple names can be represented as a vector.}

\item{\code{metadata}}{List file with this metadata field values. List only
files that have the specified value in metadata field. Different
metadata fields are represented as a named list. You can also define
multiple instances of the same metadata field.}

\item{\code{origin}}{Task object. List only files produced by task.}

\item{\code{tag}}{Filters the files based on the specified tag(s). Each tag
must be an exact, complete match, for the results to match. Tags may
include spaces. Multiple tags should be provided as a vector of
strings. The method will return files that have any of the specified
tags.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{File}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Query files in a project
 files_object$query(project = project)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-get"></a>}}
\if{latex}{\out{\hypertarget{method-Files-get}{}}}
\subsection{Method \code{get()}}{
This call returns a single File object with its details.
The call returns the file's name, its tags, and all of its metadata.
Files are specified by their IDs, which you can obtain by making
the API call to list all files in a project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The file ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{File}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Get file using id
 files_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Files-delete}{}}}
\subsection{Method \code{delete()}}{
This call removes a file from the Seven Bridges Platform.
Files are specified by their IDs, which you can obtain by using
\code{Files$query()} to list files or by getting a single file
using \code{Files$get()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$delete(file, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{\code{\link{File}} object or file ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Delete a file
 files_object$delete(file = file)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-copy"></a>}}
\if{latex}{\out{\hypertarget{method-Files-copy}{}}}
\subsection{Method \code{copy()}}{
Copy file/files to the specified project. This call allows
you to copy files between projects. Unlike the call to copy a file
between projects, this call lets you batch the copy operation and copy
a list of files at a time. \cr
More information can be found here
\href{https://docs.sevenbridges.com/reference/copy-files-between-projects}{here}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$copy(files, destination_project)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{The list of files' IDs or list of File object to copy.}

\item{\code{destination_project}}{Project object or project ID.
where you want to copy files into.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Copy files to a project
 files_object$copy(
               file = file,
               destination_project = project
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-create_folder"></a>}}
\if{latex}{\out{\hypertarget{method-Files-create_folder}{}}}
\subsection{Method \code{create_folder()}}{
A method for creating a new folder. It allows you to create
a new folder on the Platform within the root folder of a specified
project or the provided parent folder. Remember that you should provide
either the destination project (as the \code{project} parameter) or the
destination folder (as the \code{parent} parameter), not both. \cr
More information you may find
\href{https://docs.sevenbridges.com/reference/create-a-folder}{here}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$create_folder(name, parent = NULL, project = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the folder you are about to create.}

\item{\code{parent}}{The ID of the parent destination folder or a File
object which must be of type \code{FOLDER}.}

\item{\code{project}}{The ID of the destination project, or a Project object.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 files_object <- Files$new(auth = auth)

 # Create folder in a project
 files_object$create_folder(
                name = name,
                project = project
               )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-bulk_delete"></a>}}
\if{latex}{\out{\hypertarget{method-Files-bulk_delete}{}}}
\subsection{Method \code{bulk_delete()}}{
This method facilitates bulk file deletion. It accepts
either a list of \code{\link{File}} objects or a list containing
files' IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$bulk_delete(files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{Either a list of \code{\link{File}} objects or a list
of strings (IDs) representing the files you intend to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None. The function only displays the IDs of the deleted files in
the console.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Delete two files by providing their IDs
 a$files$bulk_delete(files = list("file_1_ID", "file_2_ID"))
}

\dontrun{
 # Delete two files by providing a list of File objects
 a$files$bulk_delete(files = list(File_Object_1, File_Object_2))
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-bulk_get"></a>}}
\if{latex}{\out{\hypertarget{method-Files-bulk_get}{}}}
\subsection{Method \code{bulk_get()}}{
This call returns the details of multiple specified files,
including file names and file metadata. The maximum number of files you
can retrieve the details for per call is 100.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$bulk_get(files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{A list of \code{\link{File}} objects or list of strings
(IDs) of the files you are querying for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} (list of \code{\link{File}} objects).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Get details of multiple files
 a$files$bulk_get(
               files = list("file_1_ID", "file_2_ID")
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-bulk_update"></a>}}
\if{latex}{\out{\hypertarget{method-Files-bulk_update}{}}}
\subsection{Method \code{bulk_update()}}{
A method that sets new information for specified files,
replacing all existing information and erasing omitted parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$bulk_update(files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{List of \code{\link{File}} objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For each of the specified files, the call sets a new \code{name},
new \code{tags}, and \code{metadata}.

When editing fields in the \code{\link{File}} objects you wish to
update, keep the following in mind:

\itemize{
\item The \code{name} field should be a string representing the new name of
the file.
\item The \code{metadata} field should be a named list of key-value pairs.
The keys and values should be strings.
\item The \code{tags} field should be an unnamed list of values.
}

The maximum number of files you can update the details for per call is
100.
}

\subsection{Returns}{
\code{\link{Collection}} (list of \code{\link{File}} objects).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Update details of multiple files
 a$files$bulk_update(
               files = list(File_Object_1, File_Object_2)
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-bulk_edit"></a>}}
\if{latex}{\out{\hypertarget{method-Files-bulk_edit}{}}}
\subsection{Method \code{bulk_edit()}}{
This method modifies the existing information for specified
files or adds new information while preserving omitted parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$bulk_edit(files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{List of \code{\link{File}} objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For each of the specified files, the call edits its \code{name},
\code{tags}, and \code{metadata}.

When editing fields in the \code{\link{File}} objects you wish to
update, keep the following in mind:

\itemize{
\item The \code{name} field should be a string representing the new name of
the file.
\item The \code{metadata} field should be a named list of key-value pairs.
The keys and values should be strings.
\item The \code{tags} field should be an unnamed list of values.
}

The maximum number of files you can update the details for per call is
100.
}

\subsection{Returns}{
\code{\link{Collection}} (list of \code{\link{File}} objects).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Edit details of multiple files
 a$files$bulk_edit(
               files = list(File_Object_1, File_Object_2)
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_bulk_copy"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_bulk_copy}{}}}
\subsection{Method \code{async_bulk_copy()}}{
This call lets you perform a bulk copy of files and
folders. Any underlying folder structure will be preserved.
You can copy:
\itemize{
\item to a folder within the same project,
\item to another project,
\item to a folder in another project.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_bulk_copy(items)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{Nested list of elements containing information about each
file/folder to be copied. For each element, you must provide:

\itemize{
\item \code{file} - The ID of the file or folder you are copying.
Copying the project root folder is not allowed.
Use the API call for listing all files to obtain the ID.
\item \code{parent} - The ID of the folder you are copying files to.
It should not be used together with \code{project}. If \code{project} is
used, the items will be imported to the root of the project
files. If \code{parent} is used, the import will take place into the
specified folder, within the project to which the folder belongs.
\item \code{project} - The project you are copying the file to.
It should not be used together with \code{parent}. If \code{parent} is
used, the import will take place into the specified folder,
within the project to which the folder belongs. If \code{project} is
used, the items will be imported to the root of the project
files.
\item \code{name} - Enter the new name for the file if you want to
rename it in the destination folder.
}
Example of the list:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{items <- list(
          list(
            file = '<file-id-1>',
            parent = '<folder-id>'
          ),
          list(
            file = '<file-id-2>',
            project = '<project-id-1>',
            name = 'copied_file.txt'
          ),
          list(
            file = '<file-id-3>',
            parent = '<parent-id-2>',
            name = 'copied_file2.txt'
          )
        )
}\if{html}{\out{</div>}}

Read more on how to \href{https://docs.sevenbridges.com/reference/copy-multiple-files}{perform async copy action on multiple files}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{AsyncJob}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Copy multiple files
 a$files$async_bulk_copy(
   items = list(
           list(
             file = '<file-id-1>',
             parent = '<folder-id>'
           ),
           list(
             file = '<file-id-2>',
             project = '<project-id-1>',
             name = 'copied_file.txt'
           ),
           list(
             file = '<file-id-3>',
             parent = '<parent-id-2>',
             name = 'copied_file2.txt'
           )
         )
  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_bulk_delete"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_bulk_delete}{}}}
\subsection{Method \code{async_bulk_delete()}}{
This call lets you perform an asynchronous bulk
deletion of files or folders. Deleting folders which aren't empty is
allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_bulk_delete(items)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{List of File objects (both \code{file} or \code{folder} type) or list
of IDs of files/folders you want to delete.
Read more on how to \href{https://docs.sevenbridges.com/reference/delete-multiple-files-and-folders}{perform async delete action on multiple files}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{AsyncJob}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Delete multiple files
 a$files$async_bulk_delete(
   items = list(file_obj1, file_obj2, "<folder-id-string>", "<file-id>")
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_bulk_move"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_bulk_move}{}}}
\subsection{Method \code{async_bulk_move()}}{
This call lets you perform a bulk move operation of files
and folders.
You can move:
\itemize{
\item to a root project folder,
\item to a subfolder within the same project or a different
project.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_bulk_move(items)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{Nested list of elements containing information about each
file/folder to be moved. For each element, you must provide:

\itemize{
\item \code{file} - The ID of the file or folder you are moving. Use the
API call for listing all files or folders to obtain the ID.
\item \code{parent} - The ID of the folder you are moving the files to,
which should not be used along with \code{project}. If \code{project} is
used, the items will be imported to the root of the project files.
If \code{parent} is used, the import will take place into the
specified folder, within the project to which the folder belongs.
\item \code{project} - The project you are moving the files to. It
should not be used together with \code{parent}. If \code{parent} is used,
the import will take place into the specified folder, within the
project to which the folder belongs. If \code{project} is used, the
items will be imported to the root of the project files.
\item \code{name} - Enter the new name for the file or folder if you
want to rename at the destination.
}
Example of the list:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{items <- list(
          list(
            file = '<file-id-1>',
            parent = '<folder-id>'
          ),
          list(
            file = '<file-id-2>',
            project = '<project-id-1>',
            name = 'moved_file.txt'
          ),
          list(
            file = '<file-id-3>',
            parent = '<parent-id-2>',
            name = 'moved_file2.txt'
          )
        )
}\if{html}{\out{</div>}}

Read more on how to \href{https://docs.sevenbridges.com/reference/move-multiple-files-or-folders}{perform async move action on multiple files}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Rules for moving files and folders:
\itemize{
\item The file ID is preserved after the move.
\item The folder ID is changed after the move.
\item The destination must be an existing folder.
\item If the target folder contains a folder with the same
name, the contents of both folders will be merged.
\item If a file with the same name already exists, the source
file will be automatically renamed (by adding a numeric
prefix).
\item You need to have WRITE permissions for both source
and destination folders.
}
}

\subsection{Returns}{
\code{\link{AsyncJob}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Move multiple files
 a$files$async_bulk_move(
   items = list(
           list(
             file = '<file-id-1>',
             parent = '<folder-id>'
           ),
           list(
             file = '<file-id-2>',
             project = '<project-id-1>',
             name = 'moved_file.txt'
           ),
           list(
             file = '<file-id-3>',
             parent = '<parent-id-2>',
             name = 'moved_file2.txt'
           )
         )
  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_get_copy_job"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_get_copy_job}{}}}
\subsection{Method \code{async_get_copy_job()}}{
This call retrieves the details of an asynchronous bulk
copy job.
This information will be available for up to a month after the job has
been completed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_get_copy_job(job_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the copy job you are querying.
This ID can be found within the API response for the call for copying
files.
The function also accepts an AsyncJob object and extracts the ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{AsyncJob}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Get details of an async copy job
 a$files$async_get_copy_job(job_id = "job-id")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_get_delete_job"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_get_delete_job}{}}}
\subsection{Method \code{async_get_delete_job()}}{
This call retrieves the details of an asynchronous bulk
deletion job. This information will be available for up to a month
after the job has been completed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_get_delete_job(job_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the delete job you are querying.
This ID can be found within the API response for the call for deleting
files.
The function also accepts an AsyncJob object and extracts the ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{AsyncJob}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Get details of an async delete job
 a$files$async_get_delete_job(job_id = "job-id")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_get_move_job"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_get_move_job}{}}}
\subsection{Method \code{async_get_move_job()}}{
This call retrieves the details of an asynchronous bulk
move job. This information will be available for up to a month after
the job has been completed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_get_move_job(job_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the move job you are querying. This ID can be
found within the API response for the call for moving files.
The function also accepts an AsyncJob object and extracts the ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link{AsyncJob}} object containing details of the move
job.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Get details of an async move job
 a$files$async_get_move_job(job_id = "job-id")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-async_list_file_jobs"></a>}}
\if{latex}{\out{\hypertarget{method-Files-async_list_file_jobs}{}}}
\subsection{Method \code{async_list_file_jobs()}}{
This call retrieves the details for all asynchronous bulk
jobs you have started. This information will be available for up to a
month after the job has been completed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$async_list_file_jobs(
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{Collection}} object containing a list of
\code{\link{AsyncJob}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Get details of the first 5 async jobs
 a$files$async_list_file_jobs(limit = 5)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Files-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Files-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Files$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
