% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.seroincidence.by.R
\name{summary.seroincidence.by}
\alias{summary.seroincidence.by}
\title{Summary Method for \code{"seroincidence.by"} Objects}
\usage{
\method{summary}{seroincidence.by}(
  object,
  confidence_level = 0.95,
  showDeviance = TRUE,
  showConvergence = TRUE,
  ...
)
}
\arguments{
\item{object}{A dataframe containing output of function \code{\link[=est.incidence.by]{est.incidence.by()}}.}

\item{confidence_level}{desired confidence interval coverage probability}

\item{showDeviance}{Logical flag (\code{FALSE}/\code{TRUE}) for reporting deviance
(-2*log(likelihood) at estimated seroincidence. Default = \code{TRUE}.}

\item{showConvergence}{Logical flag (\code{FALSE}/\code{TRUE}) for reporting convergence (see
help for \code{\link[=optim]{optim()}} for details). Default = \code{FALSE}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A \code{summary.seroincidence.by} object, which is a \link[tibble:tibble]{tibble::tibble}, with the following columns:
\itemize{
\item \code{incidence.rate} maximum likelihood estimate of \code{lambda} (seroincidence)
\item \code{CI.lwr} lower confidence bound for lambda
\item \code{CI.upr} upper confidence bound for lambda
\item \code{Deviance} (included if \code{showDeviance = TRUE}) Negative log likelihood (NLL) at estimated (maximum likelihood)
\code{lambda})
\itemize{
\item \code{nlm.convergence.code} (included if \code{showConvergence = TRUE}) Convergence information returned by \code{\link[stats:nlm]{stats::nlm()}}
The object also has the following metadata (accessible through \code{\link[base:attr]{base::attr()}}):
}
\item \code{antigen_isos} Character vector with names of input antigen isotypes used in \code{\link[=est.incidence.by]{est.incidence.by()}}
\item \code{Strata} Character with names of strata used in \code{\link[=est.incidence.by]{est.incidence.by()}}
}
}
\description{
Calculate seroincidence from output of the seroincidence calculator
\code{\link[=est.incidence.by]{est.incidence.by()}}.
}
\examples{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

# estimate seroincidence
est2 <- est.incidence.by(
  strata = c("catchment"),
  pop_data = xs_data,
  curve_params = curve,
  noise_params = noise,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  #num_cores = 8 # Allow for parallel processing to decrease run time
)

# calculate summary statistics for the seroincidence object
summary(est2)

}
