% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_noise_params.R
\name{load_noise_params}
\alias{load_noise_params}
\title{Load noise parameters}
\usage{
load_noise_params(file_path, antigen_isos = NULL)
}
\arguments{
\item{file_path}{path to an RDS file containing biologic
and measurement noise of antibody decay curve parameters
\code{y.low}, \code{eps}, \code{nu}, and \code{y.high},
stored as a \code{\link[=data.frame]{data.frame()}} or \link[tibble:tbl_df-class]{tibble::tbl_df}}

\item{antigen_isos}{\code{\link[=character]{character()}} vector
of antigen isotypes to be used in analyses}
}
\value{
a \code{noise} object (a \link[tibble:tbl_df-class]{tibble::tbl_df}
with extra attribute \code{antigen_isos})
}
\description{
Load noise parameters
}
\examples{
noise <- load_noise_params(serocalculator_example("example_noise_params.rds"))
print(noise)

}
