% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.loglik.R
\name{graph_loglik}
\alias{graph_loglik}
\title{Graph log-likelihood of data}
\usage{
graph_loglik(
  pop_data,
  curve_params,
  noise_params,
  antigen_isos = pop_data \%>\% get_biomarker_levels(),
  x = 10^seq(-3, 0, by = 0.1),
  highlight_points = NULL,
  highlight_point_names = "highlight_points",
  log_x = FALSE,
  previous_plot = NULL,
  curve_label = paste(antigen_isos, collapse = " + "),
  ...
)
}
\arguments{
\item{pop_data}{a \code{\link[=data.frame]{data.frame()}} with cross-sectional serology data
by antibody and age, and additional columns}

\item{curve_params}{a \code{\link[=data.frame]{data.frame()}} containing MCMC samples of parameters
from the Bayesian posterior distribution of a longitudinal decay curve model.
The parameter columns must be named:
\itemize{
\item \code{antigen_iso}: a \code{\link[=character]{character()}} vector indicating antigen-isotype
combinations
\item \code{iter}: an \code{\link[=integer]{integer()}} vector indicating MCMC sampling iterations
\item \code{y0}: baseline antibody level at $t=0$ ($y(t=0)$)
\item \code{y1}: antibody peak level (ELISA units)
\item \code{t1}: duration of infection
\item \code{alpha}: antibody decay rate
(1/days for the current longitudinal parameter sets)
\item \code{r}: shape factor of antibody decay
}}

\item{noise_params}{a \code{\link[=data.frame]{data.frame()}} (or \code{\link[tibble:tibble]{tibble::tibble()}})
containing the following variables,
specifying noise parameters for each antigen isotype:
\itemize{
\item \code{antigen_iso}: antigen isotype whose noise parameters are being specified
on each row
\item \code{nu}: biological noise
\item \code{eps}: measurement noise
\item \code{y.low}: lower limit of detection for the current antigen isotype
\item \code{y.high}: upper limit of detection for the current antigen isotype
}}

\item{antigen_isos}{Character vector listing one or more antigen isotypes.
Values must match \code{pop_data}.}

\item{x}{sequence of lambda values to graph}

\item{highlight_points}{a possible highlighted value}

\item{highlight_point_names}{labels for highlighted points}

\item{log_x}{should the x-axis be on a logarithmic scale (\code{TRUE})
or linear scale (\code{FALSE}, default)?}

\item{previous_plot}{if not NULL, the current data is added to the
existing graph}

\item{curve_label}{if not NULL, add a label for the curve}

\item{...}{
  Arguments passed on to \code{\link[=log_likelihood]{log_likelihood}}
  \describe{
    \item{\code{verbose}}{logical: if TRUE, print verbose log information to console}
  }}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Graph log-likelihood of data
}
\examples{

library(dplyr)
library(tibble)

# Load cross-sectional data
xs_data <-
  sees_pop_data_pk_100

# Load curve parameters and subset for the purposes of this example
curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

# Load noise parameters
cond <- tibble(
  antigen_iso = c("HlyE_IgG", "HlyE_IgA"),
  nu = c(0.5, 0.5),                          # Biologic noise (nu)
  eps = c(0, 0),                             # M noise (eps)
  y.low = c(1, 1),                           # Low cutoff (llod)
  y.high = c(5e6, 5e6))                      # High cutoff (y.high)

# Graph the log likelihood
lik_HlyE_IgA <- # nolint: object_name_linter
  graph_loglik(
    pop_data = xs_data,
    curve_params = curve,
    noise_params = cond,
    antigen_isos = "HlyE_IgA",
    log_x = TRUE
)

lik_HlyE_IgA # nolint: object_name_linter

}
