% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Err_RADseq.R
\name{Err_RADseq}
\alias{Err_RADseq}
\title{Convert Genotyping Error Rates from per-allele to per-locus}
\usage{
Err_RADseq(E0 = 0.005, E1 = 0.05, Return = "vector")
}
\arguments{
\item{E0}{per-allele genotyping rates at homozygous sites}

\item{E1}{per-allele genotyping rates at heterozygous sites}

\item{Return}{output format, 'vector' (default) or 'matrix'}
}
\value{
Depending on \code{Return}, either:
 \itemize{
   \item \code{'vector'}: a length 3 vector, with the probabilities (observed
     given actual) hom|other hom, het|hom, and hom|het.
   \item \code{'matrix'}: a 3x3 matrix, with probabilities of observed
     genotypes (columns) conditional on actual (rows)
 }
}
\description{
Convert per-allele genotyping rates at homozygous (E0) and
  heterozygous (E1) sites to a length-3 vector with per-locus error rates
  hom|hom, het|hom, hom|het.
}
\details{
Estimation of per-allele genotyping rates is described in Bresadola
  et al (2020) - 'Estimating and accounting for genotyping errors in RAD-seq
  experiments', MER. The error model implemented here is identical to that in
  Table 1 of that paper, and the default values are also taken from that
  paper.

For further information on how the sequoia package handles genotyping errors,
 see \code{\link{ErrToM}}.
}
\examples{
# Compare with default error pattern (SNP chip based) :
Err_RADseq(E0=0.001, E1=0.05)
ErrToM(0.05*(1-0.05)*2, Return='vector')

# usage in sequoia() and other functions:
Err_low <- Err_RADseq(E0=0.002, E1=0.05)
Err_high <- Err_RADseq(E0=0.01, E1=0.15)
\dontrun{
 SeqOUT_lowErr <- sequoia(GenoM, LHdata, Err=Err_low)
 SeqOUT_highErr <- sequoia(GenoM, LHdata, Err=Err_high)

# also usable for confidence estimates, and to explore potential consequences
# of the actual genotyping error rate being much higher/lower than assumed
EC <- EstConf(best_pedigree, LHdata, args.sim=list(SnpError=Err_high),
         args.seq=list(Err=Err_low))
}
}
