% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripes.R
\name{sonifyStripes}
\alias{sonifyStripes}
\title{Climate stripes sonification}
\usage{
sonifyStripes(
  values = sequenceR::globalT$Anomaly,
  bpm = 135,
  minVol = 0.1,
  nma = 10,
  pClap = 0.15,
  synthVar = 0.5,
  kick = sequenceR::mini909$bass,
  hihat = sequenceR::mini909$hihat,
  openHihat = sequenceR::mini909$hihat_o,
  posPercussion = sequenceR::mini909$snare,
  negPercussion = sequenceR::mini909$clap,
  bassNote = "E1",
  chord1 = c("E2", "E3", "G3", "D4", "Gb4"),
  chord2 = c("E2", "D3", "Gb3", "A3", "E4"),
  chord3 = c("E2", "B2", "Gb3", "G3", "D4"),
  videoFile = NULL,
  videoResFactor = 1
)
}
\arguments{
\item{values}{Numeric vector, values to sonify. Default is global temperature anomalies over the period 1850-2021}

\item{bpm}{Numeric > 0, tempo in beat per minute}

\item{minVol}{Numeric >= 0, minimum volume reached when smoothed series is minimum}

\item{nma}{Numeric >=0 , number of moving average steps on each side of the current value
(i.e. moving average window is 2*nma+1 when possible, nma+1 on the series' edges)}

\item{pClap}{Numeric in (0,0.5). "Large" anomalies triggering claps/snare are defined
as anomalies below (resp. above) the pClap (resp. (1-pClap))-quantile of anomalies.}

\item{synthVar}{Numeric >= 0 , controls the variability of the synthesizer sound.
When zero, the synthesizer sound does not change.
Large values induce more variability in the synthesizer sound.}

\item{kick}{soundSample, sound sample used to play the kick drum.}

\item{hihat}{soundSample, sound sample used to play the closed hi-hat.}

\item{openHihat}{soundSample, sound sample used to play the open hi-hat.}

\item{posPercussion}{soundSample, sound sample used to play the positive-anomaly percussion.}

\item{negPercussion}{soundSample, sound sample used to play the negative-anomaly percussion.}

\item{bassNote}{string, bass note (in \href{https://en.wikipedia.org/wiki/Scientific_pitch_notation}{scientific pitch notation}).}

\item{chord1}{string vector, first chord played by synthesizer.}

\item{chord2}{string vector, second chord played by synthesizer.}

\item{chord3}{string vector, third chord played by synthesizer.}

\item{videoFile}{file path, full path to video file. When NULL, video is not created.}

\item{videoResFactor}{Numeric > 0 , video resolution, 2 recommended for good-quality video.}
}
\value{
A list with the following components:
\itemize{
 \item mix, tuneR::Wave object, the final mix of the sonification.
 \item dat, data frame with 4 columns: time step, raw value, smoothed value, anomaly
 \item quantiles, numeric vector of size 2, the quantiles defining large negative/positive anomalies
 \item waves, list of tuneR::Wave object, individual waves for each instrument in case you wish to
       mix them in your own way.
}
}
\description{
Sonification of climate stripes data, or more generally, of a time series of values.
A smoothed version of the time series is computed by moving average, then sonification
proceeds as follows:
\itemize{
\item Backtrack is a standard house-like tune, including a four-on-the-floor
     kick+hi-hat pattern on the drum, a bass following the drum kick, and 3 chords
     played by a synthesizer
\item The smoothed time series controls the master volume and the amount of 'distortion'
     in the synthesizer's sound
\item Large anomalies below / above the smoothed series trigger percussion sounds (by default
     a snare and a hand clap) that are panned full left (negative anomalies) and full
     right (positive anomalies)
}
}
\examples{
w <- sonifyStripes()
}
