% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.seqtest.R
\name{print.seqtest}
\alias{print.seqtest}
\title{Print seqtest}
\usage{
\method{print}{seqtest}(x, ...)
}
\arguments{
\item{x}{\code{seqtest} object.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{seqtest} object
}
\examples{

#--------------------------------------
# Sequential triangular test for the arithmetic mean in one sample

seq.obj <- seqtest.mean(56, mu = 50, theta = 0.5,
                        alpha = 0.05, beta = 0.2, output = FALSE)

print(seq.obj)

#--------------------------------------
# Sequential triangular test for the proportion in one sample

seq.obj <- seqtest.prop(c(1, 1, 0, 1), pi = 0.5, delta = 0.2,
                        alpha = 0.05, beta = 0.2, output = FALSE)

print(seq.obj)

#--------------------------------------
# Sequential triangular test for Pearson's correlation coefficient

seq.obj <- seqtest.cor(0.46, k = 14, rho = 0.3, delta = 0.2,
                       alpha = 0.05, beta = 0.2, output = FALSE)

print(seq.obj)
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
\references{
Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Boca Raton: Chapman & Hall/CRC.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Schneider, B., Rasch, D., Kubinger, K. D., & Yanagida, T. (2015).
A Sequential triangular test of a correlation coefficient's null-hypothesis: 0 \eqn{< \rho \le \rho}0.
\emph{Statistical Papers, 56}, 689-699.
}
\seealso{
\code{\link{seqtest.mean}}, \code{\link{seqtest.prop}}, \code{\link{seqtest.cor}}, \code{\link{plot.seqtest}}, \code{\link{descript}}
}

