% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_downweighted_zero.R
\name{average_downweighted_zero}
\alias{average_downweighted_zero}
\alias{average_weighted_mixed_sentiment}
\alias{average_mean}
\title{Downweighted Zeros Averaging}
\usage{
average_downweighted_zero(x, na.rm = TRUE, ...)

average_weighted_mixed_sentiment(
  x,
  mixed.less.than.zero.weight = 4,
  na.rm = TRUE,
  ...
)

average_mean(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{logical.  Should \code{NA} values should be stripped before the 
computation proceeds.}

\item{mixed.less.than.zero.weight}{The weighting factor to multiply the 
negative elements of the vector by (this increases the intensity of the 
negatives in the numerator of the mean formula).}

\item{\ldots}{ignored.}
}
\value{
Returns a scalar summary of the re-weighted average
}
\description{
\code{average_downweighted_zero}- Downweight the zeros in a vector for 
averaging.  This is useful in the context of language where we don't want the 
neutral sentences to have such a strong influence on the general sentiment of 
the discourse with multiple sentences.  Essentially, this means neutral 
sentences are seen as having less emotional impact than a polarized sentence.

\code{average_weighted_mixed_sentiment}- Upweight the negative values in a 
vector while also downweighting the zeros in a vector.  Useful for small text
chunks with several sentences in which some one states a negative sentence
but then uses the social convention of several positive sentences in an 
attempt to negate the impact of the negative.  The affective state isn't
a neutral but a slightly lessened negative state.

\code{average_mean}- Standard mean averaging with \code{na.rm} set to \code{TRUE}.
}
\examples{
x <- c(1, 2, 0, 0, 0, -1)
mean(x)
average_downweighted_zero(x)
average_downweighted_zero(c(NA, x))
mean(c(0, 0, 0, x))
average_downweighted_zero(c(0, 0, 0, x))
}
