% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.historical}
\alias{sensibo.pod.historical}
\title{Probe the historical measurements sent by a given air conditioner (pod) for up to 7 days in the past.}
\usage{
sensibo.pod.historical(pod, days = 1, key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{days}{(integer) The number of days of measurements to get (max 7), including current day.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A data frame with with time, temperature and humidity values.
}
\description{
Probe the historical measurements sent by a given air conditioner (pod) for up to 7 days in the past.
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Get a week of data values from the first pod
pod.data <- sensibo.pod.historical(pods.id[1], days = 7)
}
}
