% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_bd.R
\name{tree_bd}
\alias{tree_bd}
\title{Phylogenetic uncertainty - net diversification rate}
\usage{
tree_bd(phy, n.tree = "all", method = "ms", track = F, ...)
}
\arguments{
\item{phy}{A phylogeny (class 'multiPhylo', see ?\code{ape}).}

\item{n.tree}{Number of times to repeat the analysis with n different trees picked 
randomly in the multiPhylo file. (If \code{n.tree} = "all", diversification will be estimated
among the set of trees provided in \code{phy})}

\item{method}{the method for estimating diversification rate ("ms" or "km") (see Details).}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylosig}}
}
\value{
The function \code{tree_bd} returns a list with the following
components:

\code{tree.bd.estimates}: Three number, diversification/speciation rate estimate 
("Magallon and Sanderson" or "Kendall-Moran") for each run with a different phylogenetic tree.

\code{stats}: Main statistics for estimates across trees.\code{CI_low} and \code{CI_high} are the lower 
and upper limits of the 95% confidence interval.
}
\description{
Performs estimates of diversification rate evaluating
uncertainty in trees topology.
}
\details{
This function estimates net diversification rate using \code{\link[geiger]{bd.ms}} 
(Magallon and Sanderson (2000) method) or speciation rate using \code{\link[geiger]{bd.km}}
(Kendall-Moran method) for n trees, randomly picked from a multiPhylo file.

Output can be visualised using \code{sensi_plot}.
}
\examples{
data("primates")
# To estimate diversification rate with Magallon and Sanderson method:
fit <- tree_bd(phy = primates.phy, n.tree = 30, method = "ms")
summary(fit)
sensi_plot(fit)
# To estimate speciation rate Kendall-Moran method
fit <- tree_bd(phy = primates.phy, n.tree = 30, method = "km")
summary(fit)
sensi_plot(fit)
}
\references{
Paterno, G. B., Penone, C. Werner, G. D. A. 
\href{http://doi.wiley.com/10.1111/2041-210X.12990}{sensiPhy: 
An r-package for sensitivity analysis in phylogenetic 
comparative methods.} Methods in Ecology and Evolution 
2018, 9(6):1461-1467

Magallon S and MJ Sanderson. 2000. Absolute diversification rates in 
angiosperm clades. Evolution 55:1762-1780.
}
\seealso{
\code{\link[geiger]{bd.ms}},
\code{\link{tree_phylm}},\code{\link{sensi_plot}}
}
\author{
Gustavo Paterno
}
