% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.sensiINTER_Clade.R
\name{sensi_plot.sensiIntra_Clade}
\alias{sensi_plot.sensiIntra_Clade}
\title{Graphical diagnostics for class 'sensiIntra_Clade'}
\usage{
\method{sensi_plot}{sensiIntra_Clade}(x, clade = NULL, graphs = "all", ...)
}
\arguments{
\item{x}{output from \code{intra_clade_phylm} or \code{intra_clade_phyglm}}

\item{clade}{The name of the clade to be evaluated (see details)}

\item{graphs}{Choose which graph should be printed on the output ("all", 1 or 2). Defaults to "all".}

\item{...}{further arguments to methods.}
}
\description{
Plot results from \code{intra_clade_phylm} and \code{intra_clade_phyglm}
}
\details{
For 'x' from intra_clade_phylm or intra_clade_phyglm:

\strong{Graph 1:} Estimated slopes after clade removal (reduced data) across multiple simulations.
 Small dots represent estimates reruns between simulations while larger 
 dots represents the average estimate between all simulations for each clade. 
 The solid black line represents the average slope estimate among trees
 using the full dataset.

\strong{Graph 2:} The effect of clade removal on slope estimate across all individual 
simulations for each clade analyzed. The black line indicates estimates 
with the full dataset while the red line represent estimates without the focal
 clade (reduced data) across different simulation The blue dots represent null expectation
 estimates after removing the same number of species of the focal clade,
 with dots falling outside the red line area indicating a larger than expected 
 absolute effect.
}
\seealso{
\code{\link[sensiPhy]{intra_clade_phylm}}
}
\author{
Gustavo Paterno, Caterina Penone
}
