% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStudiesSDESIGN.R
\name{getStudiesSDESIGN}
\alias{getStudiesSDESIGN}
\title{Extract a list of SEND studies with a specified study design - or just add
actual study design for each study.}
\usage{
getStudiesSDESIGN(
  dbToken,
  studyList = NULL,
  studyDesignFilter = NULL,
  exclusively = TRUE,
  inclUncertain = FALSE,
  noFilterReportUncertain = TRUE
)
}
\arguments{
\item{dbToken}{Mandatory.\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{studyList}{Optional, data.table.\cr
A table with the list of studies to process. If empty, all studies in
the data base are processed\cr
The table must include at least a column named 'STUDYID'}

\item{studyDesignFilter}{Mandatory, character. The study design to use as
criterion for filtering of the study id values. It can be a single string,
a vector or a list of multiple strings.}

\item{exclusively}{Mandatory, boolean.
\itemize{
\item TRUE: Include studies only for studies with no other study
design(s) than included in \code{studyDesignFilter}.
\item FALSE: Include all studies with study design matching
\code{studyDesignFilter}.
}}

\item{inclUncertain}{Mandatory, boolean.\cr
Indicates whether study ids with SDESIGN value which are is missing or wrong
shall be included or not in the output data table.}

\item{noFilterReportUncertain}{Mandatory, boolean\cr
Only relevant if the \code{studyDesignFilter} is empty.\cr
Indicates if the reason should be included if the SDESIGN cannot be
confidently decided for an animal.}
}
\value{
The function returns a data.table with columns:
\itemize{
\item STUDYID       (character)
\item Additional columns contained in the \code{studyList} table (if such
an input table is given)
\item SDESIGN       (character)\cr
If multiple TSPARMCD 'SDESIGN' values are extratced for a studies, all the
values are merged into a comma separated string.
\item UNCERTAIN_MSG (character)\cr
Included when parameter \code{inclUncertain=TRUE}.\cr
Contains indication of whether STSTDTC is missing of has wrong
format.\cr
Is NA for rows where SDESIGN is valid.\cr
A non-empty UNCERTAIN_MSG value generated by this function is merged with
non-empty UNCERTAIN_MSG values which may exist in the optional input set of
studies specified in \code{studyList} - separated by '|'.
\item NOT_VALID_MSG (character)\cr
Included when parameter \code{noFilterReportUncertain=TRUE}.\cr
In case the SDESIGN cannot be confidently decided, the column contains an
indication of the reason.\cr
Is NA for rows where SDESIGN can be confidently decided.\cr
A non-empty NOT_VALID_MSG value generated by this function is merged with
non-empty NOT_VALID_MSG values which may exist in the input set of studies
specified in \code{studyList} - separated by '|'.
}
}
\description{
Returns a data table with the list of study ids from TS where the value of
TSVAL for the TSPARMCD 'SDESIGN' is equal to a given study design.\cr
If the \code{studyDesignFilter} is empty (null, na or empty string) - all
rows for the TSPARMCD 'SDESIGN' are returned.
}
\details{
Extracts the set of studies from TS where the value of TSVAL for the TSPARMCD
'SDESIGN' is equal to a given study design.\cr
The comparison of study design values are done case insensitive.\cr

If a data table with a list of studies is specified in \code{studyList}, only
the subset of studies included in that set is processed.

If input parameter \code{inclUncertain=TRUE}, uncertain animals are included
in the output set. These uncertain situations are identified and reported (in
column UNCERTAIN_MSG):
\itemize{
\item without any row for TSPARMCD='SDESIGN' or
\item TSVAL doesn't contain a value included in the  CDISC CT list
'DESIGN' for TSPARMCD='SDESIGN' (case insensitive comparison)
}
The same checks are performed and reported in column NOT_VALID_MSG if
\code{studyDesignFilter} is empty and \code{noFilterReportUncertain=TRUE}.
}
\examples{
\dontrun{
GetStudyListSDESIGN(myDbToken, 'PARALLEL')
}
}
