% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populateDBFunctions.R
\name{dbImportStudies}
\alias{dbImportStudies}
\title{Import SEND study data in SAS xport format into a SEND database from a
hierarchy study folders.}
\usage{
dbImportStudies(
  dbToken,
  xptPathRoot,
  overWrite = FALSE,
  checkRequiredVars = TRUE,
  verbose = FALSE,
  logFilePath = NULL
)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{xptPathRoot}{Mandatory, character\cr
Root location of a set of sub folders - each sub folder with a set of SAS xport
files for one study to import.\cr
The folder tree is traversed recursively - i.e. a multilevel folder
hierarchy is allowed.}

\item{overWrite}{Mandatory, boolean\cr
Whether an already existing study in the database may be overwritten by
newly imported data.}

\item{checkRequiredVars}{Mandatory, boolean\cr
Whether not-required domains are checked for existence and content of
required variables}

\item{verbose}{Mandatory, boolean\cr
Whether the status of the import shall be continuously written to the
console for for each processed sub folder.}

\item{logFilePath}{Optional, character\cr
A path to a folder to contain a log file with the status of the import for
each processed sub folder.\cr
The name of the log file is \code{logFilePath/dbImportStudies_<date &
  time>.log} where \code{<date & time>} is the actual date and time in format
\code{YYYYmmdd_HH24MISS} - e.g. \code{dbImportStudies_20210323_084150.log}
if the function was called 23. March 2021 at 8:41:50}
}
\value{
A list containing a named element with the import status for each
of the processed sub folders.\cr
Each of the statuses are one of three variants:
\itemize{
\item 'OK' - the SAS xport files has been imported to the database with
no errors or warnings
\item 'Warning: [list of warnings]' - the SAS xport files has been
imported to the database but have one or more warnings
\item 'Cancelled: [error message]' - the SAS xport files have not been
imported to the database because an error has been detected.
}
}
\description{
For each non-empty folder below the specified root folder, the actions to
import a set of SAS xpt files into the opened SQLlite database described
for function \link{dbImportOneStudy}.
}
\details{
The status for the processing of each sub folder is caught and returned as
described below.\cr
If parameter \code{verbose = TRUE}, the status for each processed sub folder
is also printed to the console each time a sub folder has been processed -
i.e. it's possible to followed the progress of the import process.
If parameter \code{logFilePath} has been specified with an existing path to a
folder, the status for each processed sub folder is also printed to a log
file in this folder each time a sub folder has been processed.

The database must be an SQLite database - no other types of databases are
supported by this function.
}
\examples{
\dontrun{
# Import studies from a set of folders - do not allow to overwrite
# existing study data in the database, follow the progress
dbImportStudies(myDbToken,'/mydatapath/studies', verbose = TRUE)
# Import studies from another set of folders - allow to overwrite existing
# study data in the database
dbImportStudies(myDbToken,'/mydatapath/project123/studies', overwrite = TRUE)
# Import studies from a set of folders , save the status of each study load
# in a log file
dbImportStudies(myDbToken,'/mydatapath/studies',
                logFilePath = '/my/log file/path')
}
}
