% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semVerClass.R
\name{semVer}
\alias{semVer}
\title{semVer is an R6 class to create an object for working with Semantic
versioning}
\description{
semVer is an R6 class to create an object for working with Semantic
versioning

semVer is an R6 class to create an object for working with Semantic
versioning
}
\examples{

## ------------------------------------------------
## Method `semVer$higherThanAll`
## ------------------------------------------------

sem <- semVer$new("3.0.0")
sem$higherThanAll(c("2.0.2", "0.1.0"))

## ------------------------------------------------
## Method `semVer$new`
## ------------------------------------------------

sem <- semVer$new("3.0.0")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{SemVerVersion}}{version of semantic versioning rules to be followed
currently only version 2.0.0 is supported.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-higherThanAll}{\code{semVer$higherThanAll()}}
\item \href{#method-new}{\code{semVer$new()}}
\item \href{#method-clone}{\code{semVer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-higherThanAll"></a>}}
\subsection{Method \code{higherThanAll()}}{
\code{higherThanAll()} test if the vector of versions passed in are
all lower than this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{semVer$higherThanAll(Versions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Versions}}{character vector of semantically formatted
version numbers}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
atomic boolean
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sem <- semVer$new("3.0.0")
sem$higherThanAll(c("2.0.2", "0.1.0"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
initializes a new semVer object with the version supplied
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{semVer$new(Version = "", SemVerVersion = "2.0.0")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Version}}{character of semantically formatted version numbers}

\item{\code{SemVerVersion}}{defaults to "2.0.0" no other options currently
available.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
semVer object holding version data
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sem <- semVer$new("3.0.0")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{semVer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
