% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimal_selenider_session.R
\name{minimal_selenider_session}
\alias{minimal_selenider_session}
\title{Create a session with custom HTML}
\usage{
minimal_selenider_session(html, js = NULL, ..., .env = rlang::caller_env())
}
\arguments{
\item{html}{A string to use as HTML. Can also be an \code{xml2} object.}

\item{js}{A string (or \code{NULL}) to use as JavaScript.}

\item{...}{Passed into \code{\link[=selenider_session]{selenider_session()}}.}

\item{.env}{The environment in which the session will be used.}
}
\value{
A \code{selenider_session} object.
}
\description{
Create a \code{selenider_session} using custom HTML/JavaScript.
}
\details{
The function works by combining \code{html} and \code{js} into a single string, then
writing this to a temporary file (and opening it in the session's browser).
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- minimal_selenider_session("<p>Example</p>")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=selenider_session]{selenider_session()}}
}
