% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMW.R
\name{SMW}
\alias{SMW}
\title{Split moving window analysis}
\usage{
SMW(yo, ws, dist = "bray", rand = c("shift", "plot"), n.rand = 99)
}
\arguments{
\item{yo}{The ordered community matrix.}

\item{ws}{The window sizes to be analyzed. Either a single value or a vector of values.}

\item{dist}{The dissimilarity index used in vegan::\code{\link[vegan]{vegdist}}. Defaults to \code{'bray'}.}

\item{rand}{The type of randomization for significance computation (Erdös et.al, 2014):
\itemize{
  \item \code{"shift"}: restricted randomization in which data belonging to the same species are randomly shifted along the data series ("Random shift");
  \item \code{"plot"}: unrestricted randomization: each sample is randomly repositioned along the data series ("Random plot").
}}

\item{n.rand}{The number of randomizations.}
}
\value{
A two-level list object (\code{class smw}) describing the SMW results for each window \code{w} analyzed. The \code{smw} object is of length \code{ws}, and each of the  \code{w} slots is a list of SMW results:
\itemize{
  \item \code{..$dp}: The raw dissimilarity profile (DP). The DP is a data frame giving the positions, labels, values of dissimilarity and z-scores for each sample;
  \item \code{..$rdp}: data frame containing the randomized DP;
  \item \code{..$md}: mean dissimilarity of the randomized DP;
  \item \code{..$sd}: standard deviation for each sample position;
  \item \code{..$oem}: overall expected mean dissimilarity;
  \item \code{..$osd}: average standard deviation for the dissimilarities;
  \item \code{..$params}: list with input arguments
}
Available methods for class \code{"smw"} are \code{print}, \code{extract} and \code{plot}.
}
\description{
Function \code{SMW} performs split moving window analysis (SMW) with randomizations tests. It may compute dissimilarities for a single window size or  for several windows sizes.
}
\examples{
data(sim1)
sim1o<-OrdData(sim1$envi,sim1$comm)
\dontshow{
pool<-SMW(yo=sim1o$yo,ws=c(40,50), n.rand=3)
}
\donttest{
ws20<-SMW(yo=sim1o$yo,ws=20)
pool<-SMW(yo=sim1o$yo,ws=c(20,30,40))
}
}
\references{
\itemize{
  \item Erdos, L., Z. Bátori, C. S. Tölgyesi, and L. Körmöczi. 2014. The moving split window (MSW) analysis in vegetation science - An overview. Applied Ecology and Environmental Research 12:787–805.
  \item Cornelius, J. M., and J. F. Reynolds. 1991. On Determining the Statistical Significance of Discontinuities with Ordered Ecological Data. Ecology 72:2057–2070.
}
}
\seealso{
\code{\link{plot.smw}}, \code{\link{extract}}.
}
\author{
Danilo Candido Vieira
}
