% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-filter-lines.R
\name{read_filter_lines}
\alias{read_filter_lines}
\title{Read and Filter Matching Lines in Text Files}
\usage{
read_filter_lines(files, pattern, ...)
}
\arguments{
\item{files}{A character vector of files to search (only for \code{seek_in()}).}

\item{pattern}{A regular expression pattern used to match lines.}

\item{...}{Additional arguments passed to \code{\link[readr:read_lines]{readr::read_lines()}}, such as
\code{skip}, \code{n_max}, or \code{locale}.}
}
\value{
A list with two elements:
\describe{
\item{\code{line_number}}{A list of integer vectors giving the line numbers of matching lines, one per file.}
\item{\code{line}}{A list of character vectors containing the matched lines, one per file.}
}
}
\description{
Reads lines from a set of text files and returns only the lines that match a specified
regular expression pattern. The function processes each file one-by-one to maintain
memory efficiency, making it suitable for reading large files. Files that cannot be
read (due to warnings or errors) are skipped with a warning.

If verbosity is enabled via \code{seekr.verbose = TRUE} and the session is interactive,
the function reports progress.
}
\details{
Files are processed sequentially to minimize memory usage, especially when working with
large files. Only the lines matching the \code{pattern} are retained for each file.

If a file raises a warning or an error during reading, it is silently skipped and
contributes an empty entry to the result lists.
}
\keyword{internal}
