% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_secuTrial.R
\name{read_secuTrial}
\alias{read_secuTrial}
\title{Read secuTrial export}
\usage{
read_secuTrial(data_dir, labels = TRUE, factor = TRUE, dates = TRUE, ...)
}
\arguments{
\item{data_dir}{string - location of the export}

\item{labels}{logical - add labels to variables and table}

\item{factor}{logical - convert categorical variables to factor variables
(ignored when reference values are not in a separate table)}

\item{dates}{logical - convert date variables}

\item{...}{options passed to \code{read_secuTrial_raw}. Can be used for passing options to read.table}
}
\value{
\code{secuTrialdata} object - a list with one data.frame for each file on the export
        and a list containing the export options
}
\description{
Convenience wrapper for \code{read_secuTrial_raw}, \code{label_secuTrial},
             \code{factorize_secuTrial} and \code{dates_secuTrial}.
}
\examples{
export_location <- system.file("extdata", "sT_exports", "lnames",
                               "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                               package = "secuTrialR")
# read all export data
sT_export <- read_secuTrial(data_dir = export_location)

}
