% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ts_aedict.R
\name{check_ts_aedict}
\alias{check_ts_aedict}
\title{Check for missing MedDRA version in TS}
\usage{
check_ts_aedict(TS)
}
\arguments{
\item{TS}{Trial Summary SDTM dataset with variables TSPARMCD and TSVAL}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing MedDRA version;
if it's present, also checking it's the current version
}
\examples{

TS1 <- data.frame(
 STUDYID = 1,
 TSPARMCD = "AEDICT",
 TSVAL = "MedDRA 22.0",
 TSVAL2 = ""
)

TS2 <- data.frame(
 STUDYID = 2,
 TSPARMCD = "AEDICT",
 TSVAL = "",
 TSVAL1 = "meddra v22.0"
)

TS3 <- data.frame(
 STUDYID = 3,
 TSPARMCD = "AEDICT",
 TSVAL = ""
)

TS4 <-data.frame(
 STUDYID = 4,
 TSPARMCD = "CMDICT",
 TSVAL = ""
)

TS5 <- data.frame(
    STUDYID = 1,
    TSPARMCD = "AEDICT",
    TSVAL = "meddra 24.0",
    TSVAL2 = ""
)

TS6 <- data.frame(
    STUDYID = 1,
    TSPARMCD = "AEDICT",
    TSVAL = "    meddra    23.0   ",
    TSVAL2 = ""
)

check_ts_aedict(TS1)
check_ts_aedict(TS2)
check_ts_aedict(TS3)
check_ts_aedict(TS4)
check_ts_aedict(TS5)
check_ts_aedict(TS6)
check_ts_aedict(rbind(TS1,TS1))

}
\author{
Vira Vrakina, Antony Howard (HackR 2021 Team Pentraxin1)
}
