% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tr_dup.R
\name{check_tr_dup}
\alias{check_tr_dup}
\title{Check for duplicate TR records}
\usage{
check_tr_dup(TR)
}
\arguments{
\item{TR}{dataframe with variables USUBJID, TRCAT, TRLINKID/TRLNKID, TRTESTCD, TRSTRESC,
TRDTC, TRSPID (if it exists)}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks for duplicate TR records and returns a data frame.
Only applies to assessments by Investigator, selected based on uppercased
TREVAL = "INVESTIGATOR" or missing or TREVAL variable does not exist.
}
\examples{

# example with an error
TR <- data.frame(
 USUBJID  = c(1,1,2,2),
 TRCAT    = c(1,1,2,2),
 TRTESTCD = c(1,1,2,2),
 TRLINKID = c(1,1,2,2),
 TRDTC = c(rep("2016-01-01",2), rep("2016-06-01",2)),
 TRSTRESC = c(1,1,2,2),
 TRSPID = "FORMNAME-R:19/L:19XXXX",
 TREVAL = "INVESTIGATOR",
 stringsAsFactors = FALSE
)

check_tr_dup(TR)

TR1 <- TR
TR1$TRSPID <- NULL

check_tr_dup(TR1)

TR2 <- TR
TR2$TREVAL <- NULL

check_tr_dup(TR2)

# example with no records flagged because issues only among IRF records
TR3 <- TR
TR3$TREVAL <- "INDEPENDENT ASSESSOR"
check_tr_dup(TR3)

# example with required variable missing
TR4 <- TR
TR4$TRLINKID <- NULL
check_tr_dup(TR4)


}
\author{
Joel Laxamana
}
