% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ss_ssdtc_dead_dthdtc.R
\name{check_ss_ssdtc_dead_dthdtc}
\alias{check_ss_ssdtc_dead_dthdtc}
\title{Check non-missing DEAD status date in SS and an according DM record with death date
where status date is greater or equal to death date}
\usage{
check_ss_ssdtc_dead_dthdtc(SS, DM)
}
\arguments{
\item{SS}{Subject Status SDTM dataset with variables USUBJID, SSDTC, SSSTRESC, VISIT}

\item{DM}{Demographics SDTM dataset with variables USUBJID, DTHDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for non-missing SS.SSDTC when SS.SSSTRESC='DEAD' and
Subject Status Date/Time of Assessments is less than
Start Date/Time of Disposition Event(SS.SSDTC < DS.DSSTDTC)
}
\examples{

SS <- data.frame(
 USUBJID = 1:5,
 SSDTC = "2020-01-02",
 SSSTRESC  = c("DEAD","DEAD","ALIVE","DEAD","ALIVE"),
 VISIT = "DAY 10"
)

DM <- data.frame(
 USUBJID = 1:5,
 DTHDTC = "2020-01-02"
)

check_ss_ssdtc_dead_dthdtc(SS, DM)

SS <- data.frame(
 USUBJID = 1:5,
 SSDTC = "2020-01-02",
 SSSTRESC  = c("DEAD","DEAD","ALIVE","DEAD","ALIVE"),
 VISIT = "FOLLOW-UP"
)

DM <- data.frame(
 USUBJID = 1:5,
 DTHDTC = c("2020-01-01","2020-01-02","2020-01-03","2020-01-04","2020-01-02")
)

check_ss_ssdtc_dead_dthdtc(SS, DM)
}
\author{
Vira Vrakina
}
