% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_oe_bcva_tot_mismatch.R
\name{check_oe_bcva_tot_mismatch}
\alias{check_oe_bcva_tot_mismatch}
\title{Check mismatch between Derived BCVA Total Score & Total BCVA Score from Data}
\usage{
check_oe_bcva_tot_mismatch(OE)
}
\arguments{
\item{OE}{Ophtho Dataset with variables USUBJID, OETESTCD, OECAT, OESCAT, OETSTDTL,
OESTRESN, OESTAT (if present), OELAT, VISIT, OEDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This ophthalmology check looks for any mismatch between the
Derived Best Corrected Visual Acuity (BCVA) Total Score &
reported Total BCVA Score from Data based on OETESTCD = "LOGSCORE" for
older studies or OETESTCD = "VACSCORE" for newer studies
}
\examples{

#Using Old Standard, FAIL Case (4m <=19, so 4m + 1m to match with Rave Total)
OE <- data.frame(
   USUBJID = 1,
   OETESTCD = c("NUMLCOR", "NUMLCOR", "LCORCON", "LOGSCORE"),
   OECAT   = rep("BEST CORRECTED VISUAL ACUITY", 4),
   OESCAT   = c("TOTAL", "TOTAL","", ""),
   OETSTDTL  = c("TESTING DISTANCE: 4M", "TESTING DISTANCE: 1M", "", ""),
   OESTRESN = c(18, 0, 30, 48),
   OESTAT= rep("", 4),
   OELOC   = rep("EYE", 4),
   OELAT   = rep("LEFT", 4),
   VISIT   = rep("SCREENING", 4),
   VISITNUM   = rep(99, 4),
   OEDTC = rep("2021-05-19", 4),
   OEDY  = rep(1, 4),
   stringsAsFactors = FALSE)

check_oe_bcva_tot_mismatch(OE)


#Using New Standard, PASS Case

OE <- data.frame(
   USUBJID = 1,
   OETESTCD = c("NUMLCOR", "NUMLCOR", "LCORCON", "VACSCORE"),
   OECAT   = rep("BEST CORRECTED VISUAL ACUITY", 4),
   OESCAT   = c("NORMAL LIGHTING SCORE", "NORMAL LIGHTING SCORE","", ""),
   OETSTDTL  = c("TESTING DISTANCE: 4M", "TESTING DISTANCE: 1M", "", ""),
   OESTRESN = c(22, 0, 30, 52),
   OESTAT= rep("", 4),
   OELOC   = rep("EYE", 4),
   OELAT   = rep("LEFT", 4),
   VISIT   = rep("SCREENING", 4),
   VISITNUM   = rep(99, 4),
   OEDTC = rep("2021-05-19", 4),
   OEDY  = rep(1, 4),
   stringsAsFactors = FALSE)
check_oe_bcva_tot_mismatch(OE)


#Using New Standard, FAIL Case (Total 4m + 1m (As 4m <=19) not equal to CRF Total Score)

OE <- data.frame(
   USUBJID = 1,
   OETESTCD = c("NUMLCOR", "NUMLCOR", "LCORCON", "VACSCORE"),
   OECAT   = "BEST CORRECTED VISUAL ACUITY",
   OESCAT   = c("NORMAL LIGHTING SCORE", "NORMAL LIGHTING SCORE","", ""),
   OETSTDTL  = c("TESTING DISTANCE: 4M", "TESTING DISTANCE: 1M", "", ""),
   OESTRESN = c(17, 12, 0, 27),
   OESTAT= "",
   OELOC   = "EYE",
   OELAT   = "LEFT",
   VISIT   = "SCREENING",
   VISITNUM   = 99,
   OEDTC = "2021-05-19",
   OEDY  = 1,
   stringsAtors = FALSE)
check_oe_bcva_tot_mismatch(OE)


#FAIL Case without optional variable, OESTAT

OE$OESTAT <- NULL
check_oe_bcva_tot_mismatch(OE)


#missing required variable, OETESTCD

OE$OETESTCD <- NULL
check_oe_bcva_tot_mismatch(OE)

}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Monarch Shah (HackR 2021 Team Eye)
}
\concept{OPHTH}
\keyword{OPHTH}
