% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mh_missing_month.R
\name{check_mh_missing_month}
\alias{check_mh_missing_month}
\title{Check for MH dates with year and day known but month unknown}
\usage{
check_mh_missing_month(MH, preproc = identity, ...)
}
\arguments{
\item{MH}{Medical History SDTM dataset with variables USUBJID, MHTERM and MHSTDTC}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for partial missing dates in medical history
start and end dates. That is, with only the month missing while the year
and day are known
}
\examples{

MH <- data.frame(USUBJID = LETTERS[1:5],
                 MHTERM = LETTERS[5:1],
                 MHSTDTC = c("2014", NA, "2014-01", "", "2014---02"),
                 stringsAsFactors = FALSE)

check_mh_missing_month(MH)

MH$MHSPID= "FORMNAME-R:2/L:2XXXX"

check_mh_missing_month(MH,preproc=roche_derive_rave_row)

}
\author{
Chandra Mannem
}
