% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_visit.R
\name{check_ex_visit}
\alias{check_ex_visit}
\title{Check for missing EX.VISIT}
\usage{
check_ex_visit(EX)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID,EXTRT,EXSTDTC,VISIT, and optional variable EXOCCUR}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks missing EX.VISIT values when EX.EXOCCUR=Y (or EX.EXOCCUR doesn't exist)
}
\examples{

 EX <- data.frame(
 USUBJID = 1:3,
 EXTRT = 1:3,
 EXSTDTC = 1:3,
 EXOCCUR = "Y",
 VISIT = NA
)

check_ex_visit(EX)

EX$EXOCCUR=NULL

check_ex_visit(EX)

EX$VISIT=NULL

check_ex_visit(EX)#

}
\author{
Jen Chen
}
