% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_ex_after_discon.R
\name{check_ds_ex_after_discon}
\alias{check_ds_ex_after_discon}
\title{Check for patients who had Start/End date of treatment after study discontinuation date}
\usage{
check_ds_ex_after_discon(DS, EX)
}
\arguments{
\item{DS}{Disposition SDTM dataset with variables USUBJID, DSSCAT, DSCAT and DSSTDTC}

\item{EX}{Exposure SDTM dataset with variables USUBJID, EXSTDTC, EXENDTC, EXTRT, EXDOSE and EXOCCUR (if available)}
}
\value{
Boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Check for patients who had Start/End date of treatment after study discontinuation date
in the DS and EX domains.
}
\examples{

DS <- data.frame(
 USUBJID = c(rep(1,2), rep(2,2)),
 DSSCAT= rep(c("STUDY COMPLETION/EARLY DISCONTINUATION", "ADVERSE EVENT"),2),
 DSCAT = rep(c("DISPOSITION EVENT", "OTHER"),2),
 DSSTDTC = c("2019-12-29", "2019-12-20", "2019-12-10", "2019-12-01"),
 stringsAsFactors = FALSE
 )

EX <- data.frame(
 USUBJID = c(rep(1,2), rep(2,2)),
 EXSTDTC = c("2019-12-20", "2019-12-28", "2019-12-26", "2019-12-27"),
 EXENDTC = c("2019-12-10", "2019-12-23", "2019-12-30", "2019-12-27"),
 EXTRT = c(rep("SOME DRUG", 2), rep("PLACEBO",2)),
 EXDOSE = c(10,10,0,0),
 stringsAsFactors = FALSE
 )

check_ds_ex_after_discon(DS, EX)

DS <- data.frame(
 USUBJID = c(rep(1,2), rep(2,2)),
 DSSCAT= rep(c("STUDY COMPLETION/EARLY DISCONTINUATION", "ADVERSE EVENT"),2),
 DSCAT = rep(c("DISPOSITION EVENT", "OTHER"),2),
 DSSTDTC = c("2019-12-29", "2019-12-20", "2019-12-10", "2019-12-01"),
 stringsAsFactors = FALSE
 )

EX <- data.frame(
 USUBJID = c(rep(1,2), rep(2,2)),
 EXSTDTC = c("2019-12-20", "2019-12-28", "2019-12-01", "2019-12-02"),
 EXENDTC = c("2019-12-10", "2019-12-23", "2020", "2020"),
 EXTRT = c(rep("SOME DRUG", 2), rep("PLACEBO",2)),
 EXDOSE = c(10,10,0,0),
 stringsAsFactors = FALSE
 )

check_ds_ex_after_discon(DS, EX)



}
\author{
Saibah Chohan, Ashley Mao, Tina Cho (HackR 2021 Team STA-R)
}
