% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_ae_discon.R
\name{check_ds_ae_discon}
\alias{check_ds_ae_discon}
\title{Check for treatment discontinuation consistency between DS and AE}
\usage{
check_ds_ae_discon(DS, AE)
}
\arguments{
\item{DS}{Disposition SDTM dataset with variables USUBJID, DSSPID, DSCAT,
DSDECOD, DSSTDTC}

\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDECOD,
AESTDTC, AEACN*}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for consistency when DS.DSSPID=DISCTX*
then there should be AE.AEACN*=DRUG WITHDRAWN
}
\examples{

AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = "01JAN2017",
 AETERM  = c("AE1","AE2","AE3","AE4","AE5"),
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEACN = c("DOSE REDUCED", "DOSE REDUCED", "DOSE NOT CHANGED",
 "DOSE NOT CHANGED", "NOT APPLICABLE"),
 stringsAsFactors = FALSE
)


DS <- data.frame(
 USUBJID = 1:5,
 DSSPID  = c('XXXDISCTXXXXX'),
 DSSTDTC = '01JAN2017',
 DSCAT   = rep("DISPOSITION EVENT", 5),
 DSSCAT   = rep("TX FORM", 5),
 DSDECOD = c("PHYSICIAN DECISION", "OTHER", "PHYSICIAN DECISION", "OTHER", "DEATH"),
 stringsAsFactors = FALSE
)

# no case
check_ds_ae_discon(DS, AE)

# 1 case
DS[3, "DSDECOD"] <- 'ADVERSE EVENT'
check_ds_ae_discon(DS, AE)

# mutliple AEACNx
AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = c("01JAN2017"),
 AETERM  = c("AE1","AE2","AE3","AE4","AE5"),
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEACN   = rep("MULTIPLE", 5),
 AEACN1  = c("DOSE REDUCED", "DOSE NOT CHANGED", "DOSE NOT CHANGED",
 "DOSE NOT CHANGED", "NOT APPLICABLE"),
 stringsAsFactors = FALSE
)

check_ds_ae_discon(DS, AE)

}
\author{
Sarwan Singh
}
