% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_usubjid_dup.R
\name{check_dm_usubjid_dup}
\alias{check_dm_usubjid_dup}
\title{Check duplicate patient records in DM based on USUBJID}
\usage{
check_dm_usubjid_dup(DM)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variable USUBJID}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for duplicate patient demographics records in DM
}
\examples{

## duplicates and same patient number across sites for 3-part USUBJID
DM <- data.frame(USUBJID = c("GO12345-00000-1000",
                             "GO12345-11111-1000",
                             "GO12345-00000-1000",
                             "GO12345-00000-1001"),
      stringsAsFactors = FALSE)

check_dm_usubjid_dup(DM)


## no duplicate IDs in the dataframe for 3-part USUBJID
DM2 <- data.frame(USUBJID = c("GO12345-00000-1000",
                              "GO12345-11111-1001",
                              "GO12345-11111-1002"),
             stringAsFactors = FALSE)

check_dm_usubjid_dup(DM2)


## duplicates for 2-part USUBJID
DM3 <- data.frame(USUBJID = c("GO12345-1000",
                              "GO12345-1000"),
            stringAsFactors = FALSE)

check_dm_usubjid_dup(DM3)


##  no duplicate IDs in the dataframe for 2-part USUBJID
DM4 <- data.frame(USUBJID = c("GO12345-1000",
                              "GO12345-1001",
                              "GO12345-1002"),
             stringAsFactors = FALSE)

check_dm_usubjid_dup(DM4)

##  dataframe with one or two additional variables, if there is variation across other variables
DM5 <- data.frame(USUBJID = c("GO12345-1000",
                              "GO12345-1000"),
                  SEX = c("M", "F"),
                  AGE = c(18, 60),
         stringAsFactors = FALSE)

check_dm_usubjid_dup(DM5)

## dataframe in which USUBJID is not present
DM6 <- data.frame(
         STUDYID = c("GO12345"),
         SEX = c("M"),
         AGE = c(72),
     stringAsFactors = FALSE)

check_dm_usubjid_dup(DM6)

}
\author{
Madeleine Ma, Stella Banjo (HackR 2021)
}
