% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_armcd.R
\name{check_dm_armcd}
\alias{check_dm_armcd}
\title{Check for missing ARM or ARMCD values in DM}
\usage{
check_dm_armcd(DM)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variables USUBJID, ARM, ARMCD}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing ARM or ARMCD values
}
\examples{

DM <- data.frame(
 USUBJID = 1:3,
 ARM = 1:3,
 ARMCD = 1:3
)

check_dm_armcd(DM)

DM$ARMCD[1] <- NA
check_dm_armcd(DM)

DM$ARM[2] <- NA
check_dm_armcd(DM)

DM$ARMCD <- NULL
check_dm_armcd(DM)


}
\author{
Rena Wang
}
