% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dd_death_date.R
\name{check_dd_death_date}
\alias{check_dd_death_date}
\title{Check if patient with Death due to AE also has Death record in DS}
\usage{
check_dd_death_date(AE, DS, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with USUBJID, AEDTHDTC, AESPID (optional)}

\item{DS}{Disposition SDTM dataset with USUBJID, DSDECOD, DSTERM}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
Flag if patient has a Death in AE (i.e. AE record with non-missing AE.AEDTHDTC)
but no Death in DS (i.e. record where DS.DSDECOD=DEATH and
DS.DSTERM contains 'DEATH' and does not contain 'PROGRESSIVE DISEASE' or 'DISEASE RELAPSE'
(so we can pick up records where DSTERM in 'DEATH','DEATH DUE TO ...' and exclude
'DEATH DUE TO PROGRESSIVE DISEASE', 'DEATH DUE TO DISEASE RELAPSE')
}
\examples{

AE <- data.frame(
 USUBJID = 1:5,
 AEDTHDTC = c("2018-01-01", "2018-01-02", "2018-01-03","2018-01-04", ""),
 AESPID="FORMNAME-R:13/L:13XXXX",
 stringsAsFactors = FALSE
)

DS <- data.frame(
 USUBJID = c(1,1,2,3,3,4),
 DSTERM=c("DEATH","RANDOM THING","ADVERSE EVENT",
          "DEATH DUE TO PROGRESSIVE DISEASE","ADVERSE EVENT",
          "DEATH DUE TO ABC"),
 DSDECOD=c("DEATH","ADVERSE EVENT","DEATH", "DEATH","OTHER", "DEATH"),
 stringsAsFactors=FALSE
)

check_dd_death_date(AE,DS)
check_dd_death_date(AE,DS,preproc=roche_derive_rave_row)

}
\author{
Edgar Manukyan, N Springfield updated on 14SEP2020
}
