% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aedthdtc_ds_death.R
\name{check_ae_aedthdtc_ds_death}
\alias{check_ae_aedthdtc_ds_death}
\title{Check for missing AEDTHDTC where DS indicates death due to AE}
\usage{
check_ae_aedthdtc_ds_death(AE, DS)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDTHDTC}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSDECOD, DSTERM, DSSTDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing AEDTHDTC values if a patient has a
DS record where DSDECOD=DEATH and DSTERM contains ADVERSE EVENT
}
\examples{

AE <- data.frame(
 USUBJID = 1:3,
 AEDTHDTC = c(NA,NA,1)
)


# older mapping 
DS <- data.frame(
 USUBJID = 1:4,
 DSTERM = c("DEATH DUE TO ADVERSE EVENT","DEATH DUE TO PROGRESSIVE DISEASE",
            "DEATH DUE TO ADVERSE EVENT","DEATH DUE TO ADVERSE EVENT")
            ,
 DSDECOD = rep("DEATH",4),
 DSSTDTC = "2020-01-01"
)

check_ae_aedthdtc_ds_death(AE,DS)

DS$DSSTDTC = NULL

check_ae_aedthdtc_ds_death(AE,DS)

# newer mapping that  
DS <- data.frame(
 USUBJID = 1:4,
 DSTERM = c("DEATH DUE TO MYOCARDIAL INFARCTION","DEATH DUE TO PROGRESSIVE DISEASE",
            "DEATH DUE TO COVID-19","DEATH")
            ,
 DSDECOD = rep("DEATH",4),
 DSSTDTC = "2020-01-01"
 )
 
# pass for study with newer mapping, as another function (check_dd_death_date.R) covers this
check_ae_aedthdtc_ds_death(AE,DS)


}
\author{
Aldrich Salva
}
