% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeacnoth_ds_disctx.R
\name{check_ae_aeacnoth_ds_disctx}
\alias{check_ae_aeacnoth_ds_disctx}
\title{Check if, whenever a patient experiences an AE leading to study discontinuation,
they also have a DS record indicating this.}
\usage{
check_ae_aeacnoth_ds_disctx(AE, DS, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDECOD, AEACNOTx}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSCAT, DSSCAT, DSDECOD}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check returns 0 obs, otherwise return subset dataframe.
}
\description{
This code checks that when a patient has an AE with AEACNOTx = "SUBJECT
DISCONTINUED FROM STUDY" (x = "H", "1", "2", ...) then there should also be a record in DS
where DS.DSSCAT = "STUDY COMPLETION/EARLY DISCONTINUATION" and DS.DSDECOD != "COMPLETED".
}
\examples{

AE <- data.frame(
    STUDYID  = "1001",
    USUBJID  = c("1","2","3","4","5","1"),
    AESTDTC  = rep('2020-05-05', 6),
    AEDECOD  = c("HEADACHE", "HEART ATTACK","CHILLS", "PNEUMONIA", "ARTHRITIS", "FATIGUE"),
    AEACNOTH = c("NONE", "SUBJECT DISCONTINUED FROM STUDY", "MULTIPLE", "NONE",
                 "SUBJECT DISCONTINUED FROM STUDY", "SUBJECT DISCONTINUED FROM STUDY"),
    AEACNOT1 = c("", "", "PROCEDURE/SURGERY", "", "", ""),
    AEACNOT2 = c("", "", "SUBJECT DISCONTINUED FROM STUDY", "", "", ""),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

DS <- data.frame(
    USUBJID = c("1","5"),
    DSCAT   = c("DISPOSITION EVENT", "DISPOSITION EVENT"),
    DSSCAT  = c("STUDY COMPLETION/EARLY DISCONTINUATION", "STUDY COMPLETION/EARLY DISCONTINUATION"),
    DSDECOD = c("ADVERSE EVENT", "ADVERSE EVENT" ),
    stringsAsFactors = FALSE
)

check_ae_aeacnoth_ds_disctx(AE, DS)
check_ae_aeacnoth_ds_disctx(AE, DS, preproc=roche_derive_rave_row)

}
\author{
Edoardo Mancini
}
