% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_blfl.R
\name{derive_blfl}
\alias{derive_blfl}
\title{Derive Baseline Flag or Last Observation Before Exposure Flag}
\usage{
derive_blfl(
  sdtm_in,
  dm_domain,
  tgt_var,
  ref_var,
  baseline_visits = character(),
  baseline_timepoints = character()
)
}
\arguments{
\item{sdtm_in}{Input SDTM domain.}

\item{dm_domain}{DM domain with the reference variable \code{ref_var}}

\item{tgt_var}{Name of variable to be derived (\code{--BLFL} or
\code{--LOBXFL} where \verb{--} is domain).}

\item{ref_var}{vector of a date/time from the
Demographics (DM) dataset, which serves as a point of comparison for other
observations in the study. Common choices for this reference variable
include "RFSTDTC" (the date/time of the first study treatment) or
"RFXSTDTC" (the date/time of the first exposure to the study drug).}

\item{baseline_visits}{A character vector specifying the baseline visits within the study.
These visits are identified as critical points for data collection at the start of the study,
before any intervention is applied.  This allows the function to assign the baseline
flag if the --DTC matches to the reference date.}

\item{baseline_timepoints}{A character vector of timepoints values in --TPT that specifies
the specific timepoints during the baseline visits when key assessments or measurements were taken.
This allows the function to assign the baseline flag if the --DTC matches to the reference date.}
}
\value{
Modified input data frame with baseline flag variable \code{--BLFL} or
last observation before exposure flag \code{--LOBXFL} added.
}
\description{
Derive the baseline flag variable (\code{--BLFL}) or the last observation before
exposure flag (\code{--LOBXFL}), from the observation date/time (\code{--DTC}), and a
DM domain reference date/time.
}
\details{
The derivation is as follows:
\itemize{
\item Remove records where the result (\code{--ORRES}) is missing. Also, exclude records
with results labeled as "ND" (No Data) or "NOT DONE" in the \code{--ORRES} column,
which indicate that the measurement or observation was not completed.
\item Remove records where the status (\code{--STAT}) indicates the observation or test
was not performed, marked as "NOT DONE".
\item Divide the date and time column (\code{--DTC}) and the reference date/time
variable (\code{ref_var}) into separate date and time components. Ignore
any seconds recorded in the time component, focusing only on hours and
minutes for further calculations.
\item Set partial or missing dates to \code{NA}.
\item Set partial or missing times to \code{NA}.
\item Filter on rows that have domain and reference dates not equal to
\code{NA}. (Ref to as \strong{X})
\item Filter \strong{X} on rows with domain date (--DTC) prior to (less than)
reference date. (Ref to as \strong{A})
\item Filter \strong{X} on rows with domain date (--DTC) equal to reference date but
domain and reference times not equal to \code{NA} and domain time prior to (less
than) reference time. (Ref to as \strong{B})
\item Filter \strong{X} on rows with domain date (--DTC) equal to reference date but
domain and/or reference time equal to NA and:
\itemize{
\item VISIT is in baseline visits list (if it exists) and
\item xxTPT is in baseline timepoints list (if it exists).
(Ref to as \strong{C})
}
\item Combine the rows from \strong{A}, \strong{B}, and \strong{C} to get a
data frame of pre-reference date observations. Sort the rows by \code{USUBJID},
\code{--STAT}, and \code{--ORRES}.
\item Group by \code{USUBJID} and \code{--TESTCD} and filter on the rows
that have maximum value from \code{--DTC}. Keep only the oak id variables and
\code{--TESTCD} (because these are the unique values). Remove any duplicate rows.
Assign the baseline flag variable, \code{--BLFL}, the last observation before
exposure flag (\code{--LOBXFL}) variable to these rows.
\item Join the baseline flag onto the input dataset based on oak id vars
}
}
\examples{
dm <- tibble::tribble(
  ~USUBJID, ~RFSTDTC, ~RFXSTDTC,
  "test_study-375", "2020-09-28T10:10", "2020-09-28T10:10",
  "test_study-376", "2020-09-21T11:00", "2020-09-21T11:00",
  "test_study-377", NA, NA,
  "test_study-378", "2020-01-20T10:00", "2020-01-20T10:00",
  "test_study-379", NA, NA,
)

dm

sdtm_in <-
  tibble::tribble(
    ~DOMAIN,
    ~oak_id,
    ~raw_source,
    ~patient_number,
    ~USUBJID,
    ~VSDTC,
    ~VSTESTCD,
    ~VSORRES,
    ~VSSTAT,
    ~VISIT,
    "VS",
    1L,
    "VTLS1",
    375L,
    "test_study-375",
    "2020-09-01T13:31",
    "DIABP",
    "90",
    NA,
    "SCREENING",
    "VS",
    2L,
    "VTLS1",
    375L,
    "test_study-375",
    "2020-10-01T11:20",
    "DIABP",
    "90",
    NA,
    "SCREENING",
    "VS",
    1L,
    "VTLS1",
    375L,
    "test_study-375",
    "2020-09-28T10:10",
    "PULSE",
    "ND",
    NA,
    "SCREENING",
    "VS",
    2L,
    "VTLS1",
    375L,
    "test_study-375",
    "2020-10-01T13:31",
    "PULSE",
    "85",
    NA,
    "SCREENING",
    "VS",
    1L,
    "VTLS2",
    375L,
    "test_study-375",
    "2020-09-28T10:10",
    "SYSBP",
    "120",
    NA,
    "SCREENING",
    "VS",
    2L,
    "VTLS2",
    375L,
    "test_study-375",
    "2020-09-28T10:05",
    "SYSBP",
    "120",
    NA,
    "SCREENING",
    "VS",
    1L,
    "VTLS1",
    376L,
    "test_study-376",
    "2020-09-20",
    "DIABP",
    "75",
    NA,
    "SCREENING",
    "VS",
    1L,
    "VTLS1",
    376L,
    "test_study-376",
    "2020-09-20",
    "PULSE",
    NA,
    "NOT DONE",
    "SCREENING",
    "VS",
    2L,
    "VTLS1",
    376L,
    "test_study-376",
    "2020-09-20",
    "PULSE",
    "110",
    NA,
    "SCREENING",
    "VS",
    2L,
    "VTLS1",
    378L,
    "test_study-378",
    "2020-01-20T10:00",
    "PULSE",
    "110",
    NA,
    "SCREENING",
    "VS",
    3L,
    "VTLS1",
    378L,
    "test_study-378",
    "2020-01-21T11:00",
    "PULSE",
    "105",
    NA,
    "SCREENING"
  )

sdtm_in

# Example 1:
observed_output <- derive_blfl(
  sdtm_in = sdtm_in,
  dm_domain = dm,
  tgt_var = "VSLOBXFL",
  ref_var = "RFXSTDTC",
  baseline_visits = c("SCREENING")
)
observed_output

# Example 2:
observed_output2 <- derive_blfl(
  sdtm_in = sdtm_in,
  dm_domain = dm,
  tgt_var = "VSLOBXFL",
  ref_var = "RFXSTDTC",
  baseline_timepoints = c("PRE-DOSE")
)
observed_output2

# Example 3: Output is the same as Example 2
observed_output3 <- derive_blfl(
  sdtm_in = sdtm_in,
  dm_domain = dm,
  tgt_var = "VSLOBXFL",
  ref_var = "RFXSTDTC",
  baseline_visits = c("SCREENING"),
  baseline_timepoints = c("PRE-DOSE")
)
observed_output3

}
