% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_jitternudge.R
\name{position_jitternudge}
\alias{position_jitternudge}
\title{Simultaneously nudge and jitter}
\usage{
position_jitternudge(
  jitter.width = NULL,
  jitter.height = 0,
  nudge.x = 0,
  nudge.y = 0,
  seed = NA
)
}
\arguments{
\item{jitter.width}{degree of jitter in x direction. Defaults to 40\% of the
resolution of the data.}

\item{jitter.height}{degree of jitter in y direction. Defaults to 0.}

\item{nudge.x}{the amount to nudge in the x direction.}

\item{nudge.y}{the amount to nudge in the y direction.}

\item{seed}{Optional seed for the random jitter}
}
\value{
Positions for data in a \code{ggplot2::ggplot} object, similar to e.g. \code{ggplot2::position_jitter}
}
\description{
Simultaneously nudge and jitter
}
\examples{
library(ggplot2)
dsub <- diamonds[ sample(nrow(diamonds), 1000), ]
ggplot(dsub, aes(x = cut, y = carat, fill = clarity)) +
  geom_boxplot(outlier.size = 0) +
  geom_point(pch = 21, position = position_jitterdodge())
}
\seealso{
\code{\link[ggplot2:position_jitter]{ggplot2::position_jitter()}}, which is the basis of this function.
}
\concept{position adjustments}
