% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Summarize scrutiny objects}
\usage{
audit(data)
}
\arguments{
\item{data}{A data frame that inherits one of the classes named below.}
}
\value{
A tibble (data frame) with test summary statistics.
}
\description{
\code{audit()} summarizes the results of scrutiny functions like
\code{\link[=grim_map]{grim_map()}} that perform tests on data frames.

See below for a record of such functions. Go to the documentation of any of
them to learn about its \code{audit()} method.
}
\details{
\code{audit()} is an S3 generic. It looks up the (invisible) scrutiny
class of a tibble returned by any function named below. You don't need to
deal with the classes directly. Behind the scenes, they mediate between
these functions and their associated summary statistics.
}
\section{Run before \code{audit()}}{
\tabular{ll}{
   \strong{Function} \tab \strong{Class} \cr
   \code{\link[=grim_map]{grim_map()}} \tab \code{"scr_grim_map"} \cr
   \code{\link[=grimmer_map]{grimmer_map()}} \tab \code{"scr_grimmer_map"} \cr
   \code{\link[=debit_map]{debit_map()}} \tab \code{"scr_debit_map"} \cr
   \code{\link[=duplicate_count]{duplicate_count()}} \tab \code{"scr_dup_count"} \cr
   \code{\link[=duplicate_count_colpair]{duplicate_count_colpair()}} \tab \code{"scr_dup_count_colpair"} \cr
   \code{\link[=duplicate_tally]{duplicate_tally()}} \tab \code{"scr_dup_tally"} \cr
   \code{\link[=duplicate_detect]{duplicate_detect()}} \tab \code{"scr_dup_detect"} \cr
   \code{\link[=audit_seq]{audit_seq()}} \tab \code{"scr_audit_seq"} \cr
   \code{\link[=audit_total_n]{audit_total_n()}} \tab \code{"scr_audit_total_n"} \cr
}
}

\examples{
# For basic GRIM-testing:
pigs1 \%>\%
  grim_map() \%>\%
  audit()

# For duplicate detection:
pigs4 \%>\%
  duplicate_count() \%>\%
  audit()
}
