% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/current_filename.R
\name{current_filename}
\alias{current_filename}
\alias{current_source_filename}
\alias{current_cli_filename}
\title{Determine a script's filename from within the script itself}
\usage{
current_filename()

current_source_filename()

current_cli_filename()
}
\value{
A character vector of length 1 if a script name can be found, otherwise
NULL.  No manipulation is done to the filename, so it may be relative or
absolute.
}
\description{
A small set of functions wrapping up the call stack and command line
inspection needed to determine a running script's filename from within the
script itself.
}
\details{
\code{current_filename()} returns the result of \code{current_source_filename()} if
not NULL, otherwise the result of \code{current_cli_filename()}, which might be
NULL.  You should use this wrapper function rather than the more-specific
functions unless you have a very specific need.

\code{current_source_filename()} returns the filename from the most recent call
to \code{\link[base]{source}} in the current call stack.  From within a
sourced script, this is the filename of the script itself.

\code{current_cli_filename()} returns the filename found on the command line
invocation of R or Rscript.  This may or may not be the caller's file if
there's been an intervening \code{\link[base]{source}}.
}
\examples{
# Put this in example.R and try running source("example.R")
# and `Rscript example.R`
filename <- current_filename()
print(filename)

}
