% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_image.R
\name{locate_ndl_in_hay}
\alias{locate_ndl_in_hay}
\title{Locate needle image  matrix position in a haystack_image matrix.
Helper function for \code{locate_image()}.}
\usage{
locate_ndl_in_hay(ndl_mt, hay_mt, exact = TRUE, timeout = 5)
}
\arguments{
\item{ndl_mt, hay_mt}{A matrix}

\item{exact}{A logical. Check matching exactly or not.}

\item{timeout}{A numeric for timeout seconds.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    A numeric pair of xy location for needle image.
}\if{html}{\out{</div>}}
}
\description{
Locate needle image  matrix position in a haystack_image matrix.
Helper function for \code{locate_image()}.
}
\examples{
haystack_image <- imager::load.example("parrots")
w <- 100
h <- 50
needle_image <- crop_image(haystack_image, 129, 257, w, h)
hay_mt <- image2gray_matrix(haystack_image)
ndl_mt <- image2gray_matrix(needle_image)
(pos <- locate_ndl_in_hay(ndl_mt, hay_mt))

found <- crop_image(haystack_image, pos[1], pos[2], w, h)
layout(c(1:3))
plot(haystack_image)
plot(needle_image)
plot(found)

}
