% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_correltable.R
\name{partial_correltable}
\alias{partial_correltable}
\title{Create partial correlation table (with stars for significance)
for scientific publication}
\usage{
partial_correltable(
  data,
  vars = NULL,
  var_names = vars,
  partialvars = NULL,
  partialvar_names = partialvars,
  method = c("pearson", "spearman"),
  use = c("pairwise", "complete"),
  round_n = 2,
  tri = c("upper", "lower", "all"),
  cutempty = c(FALSE, TRUE),
  colnum = c(FALSE, TRUE),
  html = c(FALSE, TRUE)
)
}
\arguments{
\item{data}{The input dataset.}

\item{vars}{A list of the names of 2+ variables to correlate,
e.g. c("Age","height","WASI"). All variables must be numeric.}

\item{var_names}{An optional list to rename the \code{vars} colnames
in the output table, e.g. c("Age (years)","Height (inches)","IQ").
Must match \code{vars} in length. If not supplied, \code{vars} will be printed as is.}

\item{partialvars}{A list of the names of 1+ variables to partial out,
e.g. c("iq","Sex","Income"). Can include numeric, binary, factor variables.}

\item{partialvar_names}{An optional list to rename the \code{partialvars}
colnames in the output table, e.g. c("IQ (WASI)","Sex","Income").
Must match \code{partialvar_names} in length.
If not supplied, \code{partialvar_names} will be printed as is.}

\item{method}{Type of correlation to calculate c("pearson", "spearman"),
based on \code{stats::cor}, default = "pearson".}

\item{use}{Use pairwise.complete.obs or restrict to complete cases
c("pairwise", "complete"), based on \code{stats::cor}, default = "pairwise".}

\item{round_n}{The number of decimal places to
round all output to (default=2).}

\item{tri}{Select output formatting c("upper", "lower","all");
KEEP the upper triangle, lower triangle, or all values, default ="upper.}

\item{cutempty}{If keeping only upper/lower triangle with \code{tri},
cut empty row/column, default=FALSE.}

\item{colnum}{For more concise column names, number row names and
just use corresponding numbers as column names,
default=FALSE, if TRUE overrides cutempty.}

\item{html}{Format as html in viewer or not (default=F, print in console),
needs library(htmlTable) installed.}
}
\value{
Output Table 1
}
\description{
The \code{partial_correltable} function can be used to create
partial correlation
table (with stars for significance) for scientific publication
This is intended to summarize partial correlations
between (\code{vars}) from an input dataset (\code{data}),
residualizing all \code{vars} by \code{partialvars}.
This function allows for numeric, binary, and factor
variables as \code{partialvars}. but only numeric \code{vars}
are used and any non-numeric \code{vars} will be dropped.
All other flags follow from \code{scipub::correltable}.
Correlations are based on \code{stats::cor}, \code{use} and \code{method}
follow from that function.
Stars indicate significance: \verb{*p<.05, **p<.01, ***p<.001}
For formatting, variables can be renamed, numbers can be rounded,
upper or lower triangle only can be selected (or whole matrix),
and empty columns/rows can be dropped if using triangles.
For more compact columns, variable names can be numbered in the
rows and column names will be corresponding numbers.
Requires \code{tidyverse} and \code{stats} libraries.
}
\examples{
partial_correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  partialvars = c("Sex", "Income"),
  tri = "lower", html = TRUE
)

partial_correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  var_names = c("Age (months)", "Height (inches)", "IQ"),
  partialvars = c("Sex", "Income"),
  tri = "upper", colnum = TRUE, html = TRUE
)

partial_correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  var_names = c("Age (months)", "Height (inches)", "IQ"),
  partialvars = c("anxT"),
  partialvar_names = "Anxiety",
  tri = "all", html = TRUE
)
}
