#' nhefs9282
#'
#' @description
#' `nhefs9282` is data from the 1982 and 1992 waves of the [NHANES I Epidemiologic Follow-up Study (NHEFS)](https://wwwn.cdc.gov/nchs/nhanes/nhefs/default.aspx)
#'  column names that end in 1982 are from the 1982 survey and column names that end in 1992 are from the 1992 survey.
#'
#' The columns are:
#'
#' * `r paste0("``",colnames(nhefs9282)[1], "``", collapse = ", ")` - Subject ID
#'
#' * `r paste0("``",colnames(nhefs9282)[2], "``", collapse = ", ")` - 1982 weight (lb)
#'
#' * `r paste0("``",colnames(nhefs9282)[3], "``", collapse = ", ")` - 1992 weight (lb)
#'
#' * `r paste0("``",colnames(nhefs9282)[4], "``", collapse = ", ")` - Did subject smoke in 1982 (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[5], "``", collapse = ", ")` - Did subject smoke in 1992 (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[6], "``", collapse = ", ")` - Sex (1 = Male, 2 = Female)
#'
#' * `r paste0("``",colnames(nhefs9282)[7], "``", collapse = ", ")` - General health (1 = Excellent, 2 = Very Good, 3 = Good, 4 = Fair, 5 = Poor)
#'
#' * `r paste0("``",colnames(nhefs9282)[8], "``", collapse = ", ")` - Told by a doctor that you had hypertension or high blood pressure? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[9], "``", collapse = ", ")` - Did a doctor ever tell you that you had any cancer? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[10], "``", collapse = ", ")` - Do you usually have a cough? Exclude clearing your throat. (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[11], "``", collapse = ", ")` - Are you usually confined to bed for moat of the day? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[12], "``", collapse = ", ")` - Did a doctor ever tell you that you had asthma? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[13], "``", collapse = ", ")` - Did a doctor ever tell you that you had chronic bronchitis, emphysema? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[14], "``", collapse = ", ")` - Did a doctor ever tell you that you had migraine? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[15], "``", collapse = ", ")` - Did a doctor ever tell you that you had heart condition or heart trouble? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[16], "``", collapse = ", ")` - Did a doctor ever tell you that you had heart condition or heart attack? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[17], "``", collapse = ", ")` - During the past week I felt depressed? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[18], "``", collapse = ", ")` - About how many cigarettes a day do you smoke? (0 means less than one a day, 1 - 100 is number of cigarettes)
#'
#' * `r paste0("``",colnames(nhefs9282)[19], "``", collapse = ", ")` - On the average, how often do you drink alcoholic beverages, that is, beer, wine or liquor? (1-31 = Number of days, 94 = recently quit drinking, 95 = more than 3 but less than 12 times a year, no more than 3 times a year)
#'
#' * `r paste0("``",colnames(nhefs9282)[20], "``", collapse = ", ")` - Do you drink coffee? (1 = Yes, 2 = No)
#'
#' * `r paste0("``",colnames(nhefs9282)[21], "``", collapse = ", ")` - In your usual day, aside from recreation, are you physically very active, moderately active, or quite inactive? (1 = very active, 2 = moderately active, 3 = quite inactive)
#'
#' * `r paste0("``",colnames(nhefs9282)[22], "``", collapse = ", ")` - Are you now married, widowed, divorced, separated or have you never been married? (1 = Married, 2 = Windowed, 3 = Divorced, 4 = Separated, 5 = Never Married)
#'
#' * `r paste0("``",colnames(nhefs9282)[23], "``", collapse = ", ")` - Would you say that you have lived most of your life in a rural area, in the city, or in the city suburbs? (1 = rural, 2 = city, 3 = city suburbs, 4 = other (small town))
#'
#' * `r paste0("``",colnames(nhefs9282)[24], "``", collapse = ", ")` - Which of these income groups represents your total combined family income for the past 12 months? (1 = < $3000, 2 = $3000 - $3999, 3 = $4000 - $4999, 4 = $5000 - $5999, 5 = $6000 - $6999, 6 = $7000 - $9999, 7 = $10000 - $14999, 8 = $15000 - $19999, 9 = $20000 - $24999, 10 = $25000 - $34999, 11 = $35000 - $49999, 12 = $50000 - $74999, 13 = $75000 - $100000)
#', 14 = over $100000)
#'
#' * `r paste0("``",colnames(nhefs9282)[25], "``", collapse = ", ")` - Age in years
#'
#' * `r paste0("``",colnames(nhefs9282)[26], "``", collapse = ", ")` - Age in years
#'
#' * `r paste0("``",colnames(nhefs9282)[27], "``", collapse = ", ")` - Current marital status (1 = married, 2 = widowed, 3 = divorced, 4 = separated, 5 = never married)
#'
#' * `r paste0("``",colnames(nhefs9282)[28], "``", collapse = ", ")` - Subject age at death
#'
#' * `r paste0("``",colnames(nhefs9282)[29], "``", collapse = ", ")` - Height (in)
#'
#' * `r paste0("``",colnames(nhefs9282)[30], "``", collapse = ", ")` - Weight (lb)
#'
#' * `r paste0("``",colnames(nhefs9282)[31], "``", collapse = ", ")` - Weight (lb)
#'
#' * `r paste0("``",colnames(nhefs9282)[32], "``", collapse = ", ")` - Weight gain (lb) weight in 1992 minus weight in 1982
#'
#' * `r paste0("``",colnames(nhefs9282)[33], "``", collapse = ", ")` - 1982 smokers that quit smoking between 1982 and 1992 (1 = yes, 2 = no)
#'
#' * `r paste0("``",colnames(nhefs9282)[34], "``", collapse = ", ")` - Income classification based on 1982 family income ( 1 = famincome1982 >= 1 & famincome1982 <= 6, 2 = famincome1982 >= 7 & famincome1982 <= 8, 3 = famincome1982 >= 9 & famincome1982 <= 10, 4 = famincome1982 >= 11 & famincome1982 <= 12, 5 = famincome1982 >= 13)
#'
#'
#'@format R data frame.
#'
"nhefs9282"
