% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/URL.R
\name{URL}
\alias{URL}
\title{URL class.}
\description{
URL class.

URL class.
}
\details{
This class represents a URL object that can be used in requests.
It handles parameters as a list, making it easy to build URLs for contacting
web services.
}
\examples{
# Create a URL object from a base URL string and a list of parameters
base.url <- c("https://www.uniprot.org", "uniprot")
params <- c(query="reviewed:yes+AND+organism:9606",
       columns='id,entry name,protein names',
       format="tab")
url <- sched::URL$new(url=base.url, params=params)

# Print the URL converted to a string
print(url$toString())


## ------------------------------------------------
## Method `URL$new`
## ------------------------------------------------

# Create a URL object
url <- sched::URL$new("https://www.my.server/", c(param1=12,
                      param2='abc'))


## ------------------------------------------------
## Method `URL$getDomain`
## ------------------------------------------------

# Create a URL object
url <- sched::URL$new("https://www.my.server/",
                      c(param1=12, param2='abc'))

# Extract the domain name
print(url$getDomain())

## ------------------------------------------------
## Method `URL$setUrl`
## ------------------------------------------------

# Create an empty URL object
url <- sched::URL$new()

# Set the URL
url$setUrl('https://www.my.server/')

# Convert the URL to a string
print(url$toString())

## ------------------------------------------------
## Method `URL$setParam`
## ------------------------------------------------

# Create an URL object
url <- sched::URL$new('https://www.my.server/')

# Set a parameter
url$setParam('a', 12)

# Convert the URL to a string
print(url$toString())

## ------------------------------------------------
## Method `URL$print`
## ------------------------------------------------

# Create an URL object
url <- sched::URL$new('https://www.my.server/')

# Print the URL object
print(url)

## ------------------------------------------------
## Method `URL$toString`
## ------------------------------------------------

# Create an URL object
url <- sched::URL$new('https://www.my.server/', c(a=12))

# Convert the URL to a string
print(url$toString())
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-URL-new}{\code{URL$new()}}
\item \href{#method-URL-getDomain}{\code{URL$getDomain()}}
\item \href{#method-URL-setUrl}{\code{URL$setUrl()}}
\item \href{#method-URL-setParam}{\code{URL$setParam()}}
\item \href{#method-URL-print}{\code{URL$print()}}
\item \href{#method-URL-toString}{\code{URL$toString()}}
\item \href{#method-URL-clone}{\code{URL$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-new"></a>}}
\if{latex}{\out{\hypertarget{method-URL-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$new(url = character(), params = character(), chomp_extra_slashes = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to access, as a character vector.}

\item{\code{params}}{The list of parameters to append to this URL. If it is an
unnamed list or vector, the values will be converted to strings and
concatenated with the \code{&} separator. If it is a named list or vector, the
names will be used as keys as in "name1=value1&name2=value2&...".}

\item{\code{chomp_extra_slashes}}{If set to TRUE, then slashes at the end and
the beginning of each element of the url vector parameter will be removed
before proper concatenation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a URL object
url <- sched::URL$new("https://www.my.server/", c(param1=12,
                      param2='abc'))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-getDomain"></a>}}
\if{latex}{\out{\hypertarget{method-URL-getDomain}{}}}
\subsection{Method \code{getDomain()}}{
Etracts the domain name from the URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$getDomain()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The domain.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a URL object
url <- sched::URL$new("https://www.my.server/",
                      c(param1=12, param2='abc'))

# Extract the domain name
print(url$getDomain())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-setUrl"></a>}}
\if{latex}{\out{\hypertarget{method-URL-setUrl}{}}}
\subsection{Method \code{setUrl()}}{
Sets the base URL string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$setUrl(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The base URL string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create an empty URL object
url <- sched::URL$new()

# Set the URL
url$setUrl('https://www.my.server/')

# Convert the URL to a string
print(url$toString())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-setParam"></a>}}
\if{latex}{\out{\hypertarget{method-URL-setParam}{}}}
\subsection{Method \code{setParam()}}{
Sets a parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$setParam(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The parameter name.}

\item{\code{value}}{The value of the parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create an URL object
url <- sched::URL$new('https://www.my.server/')

# Set a parameter
url$setParam('a', 12)

# Convert the URL to a string
print(url$toString())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-print"></a>}}
\if{latex}{\out{\hypertarget{method-URL-print}{}}}
\subsection{Method \code{print()}}{
Displays information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self as invisible.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create an URL object
url <- sched::URL$new('https://www.my.server/')

# Print the URL object
print(url)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-toString"></a>}}
\if{latex}{\out{\hypertarget{method-URL-toString}{}}}
\subsection{Method \code{toString()}}{
Gets the URL as a string representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$toString(encode = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{encode}}{If set to TRUE, then encodes the URL.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The URL as a string, with all parameters and values set.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create an URL object
url <- sched::URL$new('https://www.my.server/', c(a=12))

# Convert the URL to a string
print(url$toString())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-URL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-URL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{URL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
