% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{smoothSignalOnGraph}
\alias{smoothSignalOnGraph}
\title{Smooth Signal on Graph}
\usage{
smoothSignalOnGraph(
  signal,
  filter,
  graph = NULL,
  lap = NULL,
  l.max = NULL,
  m = 50,
  ...
)
}
\arguments{
\item{signal}{signal to be smoothed}

\item{filter}{function that accepts signal `x` and the maximal Laplacian eigenvalue `l.max`. See \code{\link{heatFilter}} as an example.}

\item{graph}{igraph object with the graph (default=NULL)}

\item{lap}{graph laplacian (default=NULL). If NULL, `lap` estimated from graph.}

\item{l.max}{maximal eigenvalue of `lap` (default=NULL). If NULL, estimated from `lap`.}

\item{m}{numeric Maximum order of Chebyshev coeff to compute (default=50)}

\item{...}{
  Arguments passed on to \code{\link[=smoothChebyshev]{smoothChebyshev}}
  \describe{
    \item{\code{n.cores}}{numeric Number of cores for parallel run (default=1)}
    \item{\code{progress.chunks}}{numeric Number of chunks per core for estimating progress (default=5). Large values are not suggested, as it may bring overhead.}
    \item{\code{progress}}{boolean Flag on whether progress must be shown (default=TRUE, i.e. 'progress.chunks > 1')}
  }}
}
\description{
Smooth Signal on Graph
}
\seealso{
Other graph smoothing: 
\code{\link{computeChebyshevCoeffs}()},
\code{\link{heatFilter}()},
\code{\link{smoothChebyshev}()}
}
\concept{graph smoothing}
